"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildGetTableColumnDefinition = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _utils = require("../utils");
var _common = require("../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/saved_objects_tagging/public/ui_api/get_table_column_definition.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const buildGetTableColumnDefinition = ({
  components,
  cache
}) => {
  return ({
    serverPaging = false
  } = {}) => {
    return {
      field: 'references',
      name: _i18n.i18n.translate('xpack.savedObjectsTagging.uiApi.table.columnTagsName', {
        defaultMessage: 'Tags'
      }),
      description: _i18n.i18n.translate('xpack.savedObjectsTagging.uiApi.table.columnTagsDescription', {
        defaultMessage: 'Tags associated with this saved object'
      }),
      sortable: serverPaging ? false : object => {
        const {
          tags
        } = (0, _common.getTagsFromReferences)(object.references, cache.getState());
        tags.sort(_utils.byNameTagSorter);
        return tags.length ? tags[0].name : undefined;
      },
      render: (references, object) => {
        return /*#__PURE__*/_react.default.createElement(components.TagList, {
          object: object,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 46,
            columnNumber: 16
          }
        });
      },
      'data-test-subj': 'listingTableRowTags'
    };
  };
};
exports.buildGetTableColumnDefinition = buildGetTableColumnDefinition;