"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverwriteModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _lib = require("../../../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/saved_objects_management/public/management_section/objects_table/components/overwrite_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OverwriteModal = ({
  conflict,
  onFinish,
  allowedTypes
}) => {
  var _typeMeta$displayName;
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    obj,
    error
  } = conflict;
  let initialDestinationId;
  let selectControl = null;
  if (error.type === 'conflict') {
    initialDestinationId = error.destinationId;
  } else {
    // ambiguous conflict must have at least two destinations; default to the first one
    initialDestinationId = error.destinations[0].id;
  }
  const [destinationId, setDestinationId] = (0, _react.useState)(initialDestinationId);
  if (error.type === 'ambiguous_conflict') {
    const selectControlLabel = _i18n.i18n.translate('savedObjectsManagement.objectsTable.overwriteModal.selectControlLabel', {
      defaultMessage: 'Object ID'
    });
    const selectProps = {
      options: error.destinations.map(destination => {
        var _destination$title;
        const header = (_destination$title = destination.title) !== null && _destination$title !== void 0 ? _destination$title : `${type} [id=${destination.id}]`;
        const lastUpdated = destination.updatedAt ? (0, _moment.default)(destination.updatedAt).fromNow() : 'never';
        const idText = `ID: ${destination.id}`;
        const lastUpdatedText = `Last updated: ${lastUpdated}`;
        return {
          value: destination.id,
          inputDisplay: destination.id,
          dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 61,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement("strong", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 62,
              columnNumber: 15
            }
          }, header), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            color: "subdued",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 63,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement("p", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 64,
              columnNumber: 17
            }
          }, idText, /*#__PURE__*/_react.default.createElement("br", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 66,
              columnNumber: 19
            }
          }), lastUpdatedText)))
        };
      }),
      onChange: value => {
        setDestinationId(value);
      }
    };
    selectControl = /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      options: selectProps.options,
      valueOfSelected: destinationId,
      onChange: selectProps.onChange,
      prepend: selectControlLabel,
      "aria-label": selectControlLabel,
      hasDividers: true,
      fullWidth: true,
      compressed: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 7
      }
    });
  }
  const {
    type,
    meta
  } = obj;
  const title = meta.title || (0, _lib.getDefaultTitle)(obj);
  const typeMeta = allowedTypes.find(t => t.name === type);
  const typeDisplayName = (_typeMeta$displayName = typeMeta === null || typeMeta === void 0 ? void 0 : typeMeta.displayName) !== null && _typeMeta$displayName !== void 0 ? _typeMeta$displayName : type;
  const bodyText = error.type === 'conflict' ? _i18n.i18n.translate('savedObjectsManagement.objectsTable.overwriteModal.body.conflict', {
    defaultMessage: '"{title}" conflicts with an existing object. Overwrite it?',
    values: {
      title
    }
  }) : _i18n.i18n.translate('savedObjectsManagement.objectsTable.overwriteModal.body.ambiguousConflict', {
    defaultMessage: '"{title}" conflicts with multiple existing objects. Overwrite one?',
    values: {
      title
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    titleProps: {
      id: confirmModalTitleId
    },
    title: _i18n.i18n.translate('savedObjectsManagement.objectsTable.overwriteModal.title', {
      defaultMessage: 'Overwrite {type}?',
      values: {
        type: typeDisplayName
      }
    }),
    cancelButtonText: _i18n.i18n.translate('savedObjectsManagement.objectsTable.overwriteModal.cancelButtonText', {
      defaultMessage: 'Skip'
    }),
    confirmButtonText: _i18n.i18n.translate('savedObjectsManagement.objectsTable.overwriteModal.overwriteButtonText', {
      defaultMessage: 'Overwrite'
    }),
    buttonColor: "danger",
    onCancel: () => onFinish(false),
    onConfirm: () => onFinish(true, destinationId),
    defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON,
    maxWidth: "500px",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, bodyText), selectControl);
};
exports.OverwriteModal = OverwriteModal;