"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRouter = getRouter;
exports.getRouterLinkProps = getRouterLinkProps;
exports.getUserHasLeftApp = getUserHasLeftApp;
exports.registerRouter = registerRouter;
exports.setUserHasLeftApp = setUserHasLeftApp;
var _history = require("history");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This file based on guidance from https://github.com/elastic/eui/blob/main/wiki/consuming-eui/react-router.md
 */

let _userHasLeftApp = false;
function setUserHasLeftApp(userHasLeftApp) {
  _userHasLeftApp = userHasLeftApp;
}
function getUserHasLeftApp() {
  return _userHasLeftApp;
}
const isModifiedEvent = event => !!(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey);
const isLeftClickEvent = event => event.button === 0;
let router;
function registerRouter(reactRouter) {
  router = reactRouter;
}
function getRouter() {
  return router;
}

/**
 * The logic for generating hrefs and onClick handlers from the `to` prop is largely borrowed from
 * https://github.com/ReactTraining/react-router/blob/master/packages/react-router-dom/modules/Link.js.
 */
function getRouterLinkProps(to) {
  const location = typeof to === 'string' ? (0, _history.createLocation)(to, null, null, router.history.location) : to;
  const href = router.history.createHref(location);
  const onClick = event => {
    if (event.defaultPrevented) {
      return;
    }

    // If target prop is set (e.g. to "_blank"), let browser handle link.
    if (event.target.getAttribute('target')) {
      return;
    }
    if (isModifiedEvent(event) || !isLeftClickEvent(event)) {
      return;
    }

    // Prevent regular link behavior, which causes a browser refresh.
    event.preventDefault();
    router.history.push(location);
  };
  return {
    href,
    onClick
  };
}