"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mlAnomalyDetectionAlertParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _utils = require("../common/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const mlAnomalyDetectionAlertParamsSchema = exports.mlAnomalyDetectionAlertParamsSchema = _configSchema.schema.object({
  jobSelection: _utils.jobsSelectionSchema,
  /** Anomaly score threshold  */
  severity: _configSchema.schema.number({
    min: 0,
    max: 100
  }),
  /** Result type to alert upon  */
  resultType: _configSchema.schema.oneOf([_configSchema.schema.literal(_mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.RECORD), _configSchema.schema.literal(_mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.BUCKET), _configSchema.schema.literal(_mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.INFLUENCER)]),
  includeInterim: _configSchema.schema.boolean({
    defaultValue: true
  }),
  /** User's override for the lookback interval */
  lookbackInterval: _configSchema.schema.nullable(_configSchema.schema.string()),
  /** User's override for the top N buckets  */
  topNBuckets: _configSchema.schema.nullable(_configSchema.schema.number({
    min: 1
  }))
});