"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStartDateValidator = void 0;
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getStartDateValidator = (today, timezone) => ({
  value
}) => {
  const valueInTimezone = value.clone().tz(timezone, true);
  if (valueInTimezone.isBefore(today)) {
    return {
      message: _translations.SCHEDULED_REPORT_FORM_START_DATE_TOO_EARLY_MESSAGE
    };
  }
};
exports.getStartDateValidator = getStartDateValidator;