"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SniffConnection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _documentation = require("../../../../../services/documentation");
var _validators = require("../validators");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/remote_clusters/public/application/sections/components/remote_cluster_config_steps/remote_cluster_form/components/sniff_connection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SniffConnection = ({
  fields,
  fieldsErrors,
  areErrorsVisible,
  onFieldsChange
}) => {
  const [localSeedErrors, setLocalSeedErrors] = (0, _react.useState)([]);
  const {
    seeds = [],
    nodeConnections
  } = fields;
  const {
    seeds: seedsError,
    nodeConnections: nodeError
  } = fieldsErrors;
  // Show errors if there is a general form error or local errors.
  const areFormErrorsVisible = Boolean(areErrorsVisible && seedsError);
  const showLocalSeedErrors = areFormErrorsVisible || localSeedErrors.length !== 0;
  const errorsInLocalSeeds = areFormErrorsVisible && seedsError ? localSeedErrors.concat(seedsError) : localSeedErrors;
  const formattedSeeds = seeds.map(seed => ({
    label: seed
  }));
  const showNodeConnectionErrors = Boolean(nodeError);
  const onCreateSeed = newSeed => {
    // If the user just hit enter without typing anything, treat it as a no-op.
    if (!newSeed) {
      return;
    }
    const validationErrors = (0, _validators.validateSeed)(newSeed);
    if (validationErrors.length !== 0) {
      setLocalSeedErrors(validationErrors);
      // Return false to explicitly reject the user's input.
      return false;
    }
    const newSeeds = seeds.slice(0);
    newSeeds.push(newSeed.toLowerCase());
    onFieldsChange({
      seeds: newSeeds
    });
  };
  const onSeedsInputChange = seedInput => {
    if (!seedInput) {
      // If empty seedInput ("") don't do anything. This happens
      // right after a seed is created.
      return;
    }

    // Allow typing to clear the errors, but not to add new ones.
    const validationErrors = !seedInput || (0, _validators.validateSeed)(seedInput).length === 0 ? [] : localSeedErrors;

    // EuiComboBox internally checks for duplicates and prevents calling onCreateOption if the
    // input is a duplicate. So we need to surface this error here instead.
    const isDuplicate = seeds.includes(seedInput);
    if (isDuplicate) {
      validationErrors.push(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.localSeedError.duplicateMessage",
        defaultMessage: "Duplicate seed nodes aren't allowed.`",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 9
        }
      }));
    }
    setLocalSeedErrors(validationErrors);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormSeedNodesFormRow",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldSeedsLabel",
      defaultMessage: "Seed nodes",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 11
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldSeedsHelpText",
      defaultMessage: "An IP address or host name, followed by the {transportPort} of the remote cluster. Specify multiple seed nodes so discovery doesn't fail if a node is unavailable.",
      values: {
        transportPort: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.transportPortUrl,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.remoteClusters.remoteClusterForm.sectionSeedsHelpText.portLinkText",
          defaultMessage: "port",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 99,
            columnNumber: 19
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 11
      }
    }),
    isInvalid: showLocalSeedErrors,
    error: errorsInLocalSeeds,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    placeholder: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.fieldSeedsPlaceholder', {
      defaultMessage: 'host:port'
    }),
    selectedOptions: formattedSeeds,
    onCreateOption: onCreateSeed,
    onChange: options => onFieldsChange({
      seeds: options.map(({
        label
      }) => label)
    }),
    onSearchChange: onSeedsInputChange,
    isInvalid: showLocalSeedErrors,
    fullWidth: true,
    "data-test-subj": "remoteClusterFormSeedsInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormNodeConnectionsFormRow",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldNodeConnectionsLabel",
      defaultMessage: "Node connections",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 11
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldNodeConnectionsHelpText",
      defaultMessage: "The number of gateway nodes to connect to for this cluster.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 11
      }
    }),
    fullWidth: true,
    isInvalid: showNodeConnectionErrors,
    error: nodeError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: nodeConnections || '',
    onChange: e => onFieldsChange({
      nodeConnections: Number(e.target.value)
    }),
    isInvalid: showNodeConnectionErrors,
    fullWidth: true,
    "data-test-subj": "remoteClusterFormNodeConnectionsInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  })));
};
exports.SniffConnection = SniffConnection;