"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlameGraphsView = FlameGraphsView;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _profiling_app_page_template = require("../../components/profiling_app_page_template");
var _redirect_to = require("../../components/redirect_to");
var _use_profiling_params = require("../../hooks/use_profiling_params");
var _use_profiling_router = require("../../hooks/use_profiling_router");
var _use_profiling_route_path = require("../../hooks/use_profiling_route_path");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/views/flamegraphs/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FlameGraphsView({
  children
}) {
  const {
    query
  } = (0, _use_profiling_params.useProfilingParams)('/flamegraphs/*');
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  if (routePath === '/flamegraphs') {
    return /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
      pathname: "/flamegraphs/flamegraph",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 12
      }
    });
  }
  const isDifferentialView = routePath === '/flamegraphs/differential';
  const tabs = [{
    label: _i18n.i18n.translate('xpack.profiling.flameGraphsView.flameGraphTabLabel', {
      defaultMessage: 'Flamegraph'
    }),
    isSelected: !isDifferentialView,
    href: profilingRouter.link('/flamegraphs/flamegraph', {
      query
    })
  }, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphsView.differentialFlameGraphTabLabel', {
      defaultMessage: 'Differential flamegraph'
    }),
    isSelected: isDifferentialView,
    href: profilingRouter.link('/flamegraphs/differential', {
      // @ts-expect-error Code gets too complicated to satisfy TS constraints
      query: {
        ...query,
        comparisonRangeFrom: query.rangeFrom,
        comparisonRangeTo: query.rangeTo,
        comparisonKuery: query.kuery
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
    tabs: tabs,
    hideSearchBar: isDifferentialView,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, children);
}