"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNextTimeRange = getNextTimeRange;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getParsedDate(rawDate, options = {}) {
  if (rawDate) {
    const parsed = _datemath.default.parse(rawDate, options);
    if (parsed && parsed.isValid()) {
      return parsed.toDate();
    }
  }
}
function getNextTimeRange({
  state = {},
  rangeFrom,
  rangeTo
}) {
  // If the previous state had the same range, just return that instead of calculating a new range.
  if (state.rangeFrom === rangeFrom && state.rangeTo === rangeTo) {
    return {
      start: state.start,
      end: state.end
    };
  }
  const start = getParsedDate(rangeFrom);
  const end = getParsedDate(rangeTo, {
    roundUp: true
  });

  // `getParsedDate` will return undefined for invalid or empty dates. We return
  // the previous state if either date is undefined.
  if (!start || !end) {
    return {
      start: state.start,
      end: state.end
    };
  }
  return {
    start: start.toISOString(),
    end: end.toISOString()
  };
}