"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.profilingRouter = void 0;
var _i18n = require("@kbn/i18n");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _profilingUtils = require("@kbn/profiling-utils");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var t = _interopRequireWildcard(require("io-ts"));
var _react = _interopRequireDefault(require("react"));
var _storage_explorer = require("../../common/storage_explorer");
var _normalization_menu = require("../components/normalization_menu");
var _redirect_to = require("../components/redirect_to");
var _add_data_view = require("../views/add_data_view");
var _delete_data_view = require("../views/delete_data_view");
var _flamegraphs = require("../views/flamegraphs");
var _differential_flamegraphs = require("../views/flamegraphs/differential_flamegraphs");
var _flamegraph = require("../views/flamegraphs/flamegraph");
var _functions = require("../views/functions");
var _differential_topn = require("../views/functions/differential_topn");
var _topn = require("../views/functions/topn");
var _settings = require("../views/settings");
var _stack_traces_view = require("../views/stack_traces_view");
var _storage_explorer2 = require("../views/storage_explorer");
var _route_breadcrumb = require("./route_breadcrumb");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/routing/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const routes = {
  '/': {
    element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
      title: _i18n.i18n.translate('xpack.profiling.breadcrumb.profiling', {
        defaultMessage: 'Universal Profiling'
      }),
      href: "/",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    })),
    children: {
      '/settings': {
        element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
          title: _i18n.i18n.translate('xpack.profiling.breadcrumb.settings', {
            defaultMessage: 'Settings'
          }),
          href: "/settings",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 54,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_settings.Settings, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 60,
            columnNumber: 13
          }
        }))
      },
      '/add-data-instructions': {
        element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
          title: _i18n.i18n.translate('xpack.profiling.breadcrumb.addDataView', {
            defaultMessage: 'Add profiling data'
          }),
          href: "/add-data-instructions",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 66,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_add_data_view.AddDataView, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 72,
            columnNumber: 13
          }
        })),
        params: t.type({
          query: t.type({
            selectedTab: t.union([t.literal(_add_data_view.AddDataTabs.Binary), t.literal(_add_data_view.AddDataTabs.Deb), t.literal(_add_data_view.AddDataTabs.Docker), t.literal(_add_data_view.AddDataTabs.ElasticAgentIntegration), t.literal(_add_data_view.AddDataTabs.Kubernetes), t.literal(_add_data_view.AddDataTabs.RPM), t.literal(_add_data_view.AddDataTabs.Symbols)])
          })
        }),
        defaults: {
          query: {
            selectedTab: _add_data_view.AddDataTabs.Kubernetes
          }
        }
      },
      '/delete_data_instructions': {
        element: /*#__PURE__*/_react.default.createElement(_delete_data_view.DeleteDataView, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 95,
            columnNumber: 18
          }
        })
      },
      '/': {
        children: {
          '/stacktraces/{topNType}': {
            element: /*#__PURE__*/_react.default.createElement(_stack_traces_view.StackTracesView, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 100,
                columnNumber: 22
              }
            }),
            params: t.type({
              path: t.type({
                topNType: t.union([t.literal(_profilingUtils.TopNType.Containers), t.literal(_profilingUtils.TopNType.Deployments), t.literal(_profilingUtils.TopNType.Executables), t.literal(_profilingUtils.TopNType.Hosts), t.literal(_profilingUtils.TopNType.Threads), t.literal(_profilingUtils.TopNType.Traces)])
              }),
              query: t.type({
                displayAs: t.union([t.literal(_profilingUtils.StackTracesDisplayOption.StackTraces), t.literal(_profilingUtils.StackTracesDisplayOption.Percentage)]),
                limit: _ioTsUtils.toNumberRt
              })
            }),
            defaults: {
              query: {
                displayAs: _profilingUtils.StackTracesDisplayOption.StackTraces,
                limit: '10'
              }
            }
          },
          '/stacktraces': {
            element: /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
              pathname: "/stacktraces/executables",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 128,
                columnNumber: 22
              }
            })
          },
          '/flamegraphs': {
            element: /*#__PURE__*/_react.default.createElement(_flamegraphs.FlameGraphsView, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 132,
                columnNumber: 15
              }
            }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 133,
                columnNumber: 17
              }
            })),
            children: {
              '/flamegraphs/flamegraph': {
                element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
                  title: _i18n.i18n.translate('xpack.profiling.breadcrumb.flamegraph', {
                    defaultMessage: 'Flamegraph'
                  }),
                  href: "/flamegraphs/flamegraph",
                  __self: void 0,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 139,
                    columnNumber: 19
                  }
                }, /*#__PURE__*/_react.default.createElement(_flamegraph.FlameGraphView, {
                  __self: void 0,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 145,
                    columnNumber: 21
                  }
                })),
                params: t.type({
                  query: t.partial({
                    searchText: t.string
                  })
                })
              },
              '/flamegraphs/differential': {
                element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
                  title: _i18n.i18n.translate('xpack.profiling.breadcrumb.differentialFlamegraph', {
                    defaultMessage: 'Differential flamegraph'
                  }),
                  href: "/flamegraphs/differential",
                  __self: void 0,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 156,
                    columnNumber: 19
                  }
                }, /*#__PURE__*/_react.default.createElement(_differential_flamegraphs.DifferentialFlameGraphsView, {
                  __self: void 0,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 162,
                    columnNumber: 21
                  }
                })),
                params: t.type({
                  query: t.intersection([t.type({
                    comparisonRangeFrom: t.string,
                    comparisonRangeTo: t.string,
                    comparisonKuery: t.string,
                    comparisonMode: t.union([t.literal(_normalization_menu.ComparisonMode.Absolute), t.literal(_normalization_menu.ComparisonMode.Relative)]),
                    normalizationMode: t.union([t.literal(_normalization_menu.NormalizationMode.Scale), t.literal(_normalization_menu.NormalizationMode.Time)])
                  }), t.partial({
                    baseline: _ioTsUtils.toNumberRt,
                    comparison: _ioTsUtils.toNumberRt,
                    searchText: t.string
                  })])
                }),
                defaults: {
                  query: {
                    comparisonRangeFrom: 'now-15m',
                    comparisonRangeTo: 'now',
                    comparisonKuery: '',
                    comparisonMode: _normalization_menu.ComparisonMode.Absolute,
                    normalizationMode: _normalization_menu.NormalizationMode.Time
                  }
                }
              }
            }
          },
          '/functions': {
            element: /*#__PURE__*/_react.default.createElement(_functions.FunctionsView, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 201,
                columnNumber: 15
              }
            }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 202,
                columnNumber: 17
              }
            })),
            params: t.type({
              query: t.type({
                sortField: _profilingUtils.topNFunctionSortFieldRt,
                sortDirection: t.union([t.literal('asc'), t.literal('desc')])
              })
            }),
            defaults: {
              query: {
                sortField: _profilingUtils.TopNFunctionSortField.Rank,
                sortDirection: 'asc'
              }
            },
            children: {
              '/functions/topn': {
                element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
                  title: _i18n.i18n.translate('xpack.profiling.breadcrumb.topnFunctions', {
                    defaultMessage: 'TopN functions'
                  }),
                  href: "/functions/topn",
                  __self: void 0,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 220,
                    columnNumber: 19
                  }
                }, /*#__PURE__*/_react.default.createElement(_topn.TopNFunctionsView, {
                  __self: void 0,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 226,
                    columnNumber: 21
                  }
                })),
                params: t.type({
                  query: t.partial({
                    pageIndex: _ioTsUtils.toNumberRt,
                    searchFunctionName: t.string
                  })
                })
              },
              '/functions/differential': {
                element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
                  title: _i18n.i18n.translate('xpack.profiling.breadcrumb.differentialFunctions', {
                    defaultMessage: 'Differential topN functions'
                  }),
                  href: "/functions/differential",
                  __self: void 0,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 235,
                    columnNumber: 19
                  }
                }, /*#__PURE__*/_react.default.createElement(_differential_topn.DifferentialTopNFunctionsView, {
                  __self: void 0,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 241,
                    columnNumber: 21
                  }
                })),
                params: t.type({
                  query: t.intersection([t.type({
                    comparisonRangeFrom: t.string,
                    comparisonRangeTo: t.string,
                    comparisonKuery: t.string,
                    normalizationMode: t.union([t.literal(_normalization_menu.NormalizationMode.Scale), t.literal(_normalization_menu.NormalizationMode.Time)]),
                    comparisonSortField: _profilingUtils.topNComparisonFunctionSortFieldRt,
                    comparisonSortDirection: t.union([t.literal('asc'), t.literal('desc')])
                  }), t.partial({
                    baseline: _ioTsUtils.toNumberRt,
                    comparison: _ioTsUtils.toNumberRt,
                    pageIndex: _ioTsUtils.toNumberRt,
                    searchFunctionName: t.string
                  })])
                }),
                defaults: {
                  query: {
                    comparisonRangeFrom: 'now-15m',
                    comparisonRangeTo: 'now',
                    comparisonKuery: '',
                    normalizationMode: _normalization_menu.NormalizationMode.Time,
                    comparisonSortField: _profilingUtils.TopNComparisonFunctionSortField.ComparisonRank,
                    comparisonSortDirection: 'asc'
                  }
                }
              }
            }
          },
          '/storage-explorer': {
            element: /*#__PURE__*/_react.default.createElement(_route_breadcrumb.RouteBreadcrumb, {
              title: _i18n.i18n.translate('xpack.profiling.breadcrumb.storageExplorer', {
                defaultMessage: 'Storage explorer'
              }),
              href: "/storage-explorer",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 280,
                columnNumber: 15
              }
            }, /*#__PURE__*/_react.default.createElement(_storage_explorer2.StorageExplorerView, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 286,
                columnNumber: 17
              }
            })),
            params: t.type({
              query: _storage_explorer.indexLifecyclePhaseRt
            }),
            defaults: {
              query: {
                indexLifecyclePhase: _storage_explorer.IndexLifecyclePhaseSelectOption.All
              }
            }
          },
          '/': {
            element: /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
              pathname: "/stacktraces/threads",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 299,
                columnNumber: 22
              }
            })
          }
        },
        element: /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 302,
            columnNumber: 18
          }
        }),
        params: t.type({
          query: t.type({
            rangeFrom: t.string,
            rangeTo: t.string,
            kuery: t.string
          })
        }),
        defaults: {
          query: {
            kuery: ''
          }
        }
      }
    }
  }
};
const profilingRouter = exports.profilingRouter = (0, _typedReactRouterConfig.createRouter)(routes);