"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APMTransactions = APMTransactions;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _common = require("../../../common");
var _use_async = require("../../hooks/use_async");
var _use_profiling_params = require("../../hooks/use_profiling_params");
var _use_time_range = require("../../hooks/use_time_range");
var _use_time_range_async = require("../../hooks/use_time_range_async");
var _as_number = require("../../utils/formatters/as_number");
var _use_profiling_dependencies = require("../contexts/profiling_dependencies/use_profiling_dependencies");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/frame_information_window/apm_transactions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const findServicesAndTransactions = (servicesAndTransactions, pageIndex, pageSize, sortField, sortDirection, filter) => {
  let filteredItems = servicesAndTransactions;
  if (!(0, _lodash.isEmpty)(filter)) {
    filteredItems = servicesAndTransactions.filter(item => item.serviceName.includes(filter));
  }
  let sortedItems;
  if (sortField) {
    sortedItems = filteredItems.slice(0).sort(_eui.Comparators.property(sortField, _eui.Comparators.default(sortDirection)));
  } else {
    sortedItems = filteredItems;
  }
  let pageOfItems;
  if (!pageIndex && !pageSize) {
    pageOfItems = sortedItems;
  } else {
    const startIndex = pageIndex * pageSize;
    pageOfItems = sortedItems.slice(startIndex, Math.min(startIndex + pageSize, filteredItems.length));
  }
  return {
    pageOfItems,
    totalItemCount: filteredItems.length
  };
};
function EstimatedLabel({
  label
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.profiling.functionsView.samplesColumnLabel.hint', {
      defaultMessage: 'Estimated values'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, label, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    color: "subdued",
    type: "question",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 17
    }
  })));
}
const SAMPLES_COLUMN_WIDTH = '152px';
function APMTransactions({
  functionName,
  serviceNames
}) {
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_profiling_params.useAnyOfProfilingParams)('/functions/*', '/flamegraphs/*');
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    services: {
      fetchTopNFunctionAPMTransactions
    },
    setup: {
      observabilityShared
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(5);
  const [sortField, setSortField] = (0, _react.useState)('serviceSamples');
  const [sortDirection, setSortDirection] = (0, _react.useState)('desc');
  const [filter, setFilter] = (0, _react.useState)('');
  const [filterDebounced, setFilterDebounced] = (0, _react.useState)('');
  (0, _useDebounce.default)(() => {
    setFilterDebounced(filter);
  }, 500, [filter]);
  const onTableChange = ({
    page,
    sort
  }) => {
    if (page) {
      const {
        index,
        size
      } = page;
      setPageIndex(index);
      setPageSize(size);
    }
    if (sort) {
      const {
        field,
        direction
      } = sort;
      setSortField(field);
      setSortDirection(direction);
    }
  };
  const initialServices = (0, _react.useMemo)(() => {
    return Object.keys(serviceNames).map(key => {
      const samples = serviceNames[key];
      return {
        serviceName: key,
        serviceSamples: samples,
        transactionName: null,
        transactionSamples: null
      };
    });
  }, [serviceNames]);
  const {
    pageOfItems,
    totalItemCount
  } = (0, _react.useMemo)(() => findServicesAndTransactions(initialServices, pageIndex, pageSize, sortField, sortDirection, filterDebounced), [initialServices, pageIndex, pageSize, sortField, sortDirection, filterDebounced]);
  const {
    status,
    data: transactionsPerServiceMap = pageOfItems
  } = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    const serviceNamesToSearch = pageOfItems.map(item => item.serviceName).sort();
    if (serviceNamesToSearch.length) {
      return fetchTopNFunctionAPMTransactions({
        http,
        timeFrom: new Date(timeRange.start).getTime(),
        timeTo: new Date(timeRange.end).getTime(),
        functionName,
        serviceNames: serviceNamesToSearch
      }).then(resp => {
        return pageOfItems.flatMap(item => {
          var _transactionDetails$t;
          const transactionDetails = resp[item.serviceName];
          if (transactionDetails !== null && transactionDetails !== void 0 && (_transactionDetails$t = transactionDetails.transactions) !== null && _transactionDetails$t !== void 0 && _transactionDetails$t.length) {
            return transactionDetails.transactions.map(transaction => ({
              ...item,
              transactionName: transaction.name,
              transactionSamples: transaction.samples
            }));
          }
          return [item];
        });
      });
    }
    return Promise.resolve(pageOfItems);
  }, [fetchTopNFunctionAPMTransactions, functionName, pageOfItems, timeRange.end, timeRange.start]);
  const isLoadingTransactions = status !== _use_async.AsyncStatus.Settled;
  const columns = (0, _react.useMemo)(() => [{
    field: 'serviceName',
    name: _i18n.i18n.translate('xpack.profiling.apmTransactions.columns.serviceName', {
      defaultMessage: 'Service Name'
    }),
    truncateText: true,
    sortable: true,
    render: (_, {
      serviceName
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "profilingColumnsLink",
        href: observabilityShared.locators.apm.serviceOverview.getRedirectUrl({
          serviceName,
          rangeFrom,
          rangeTo
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 13
        }
      }, serviceName);
    }
  }, {
    field: 'serviceSamples',
    width: SAMPLES_COLUMN_WIDTH,
    sortable: true,
    name: /*#__PURE__*/_react.default.createElement(EstimatedLabel, {
      label: _i18n.i18n.translate('xpack.profiling.apmTransactions.columns.serviceSamplesName', {
        defaultMessage: 'Service Samples'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 11
      }
    }),
    render(_, {
      serviceSamples
    }) {
      return (0, _as_number.asNumber)(serviceSamples);
    }
  }, {
    field: 'transactionName',
    name: _i18n.i18n.translate('xpack.profiling.apmTransactions.columns.transactionName', {
      defaultMessage: 'Transaction Name'
    }),
    truncateText: true,
    render(_, {
      serviceName,
      transactionName
    }) {
      if (isLoadingTransactions) {
        return '--';
      }
      if (transactionName) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "profilingColumnsLink",
          href: observabilityShared.locators.apm.transactionDetailsByName.getRedirectUrl({
            serviceName,
            transactionName,
            rangeFrom,
            rangeTo
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 245,
            columnNumber: 15
          }
        }, transactionName);
      }
      return _common.NOT_AVAILABLE_LABEL;
    }
  }, {
    field: 'transactionSamples',
    name: /*#__PURE__*/_react.default.createElement(EstimatedLabel, {
      label: _i18n.i18n.translate('xpack.profiling.apmTransactions.columns.transactionSamples', {
        defaultMessage: 'Transaction Samples'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 11
      }
    }),
    width: SAMPLES_COLUMN_WIDTH,
    render(_, {
      transactionSamples
    }) {
      if (isLoadingTransactions) {
        return '--';
      }
      if (transactionSamples === null) {
        return _common.NOT_AVAILABLE_LABEL;
      }
      return (0, _as_number.asNumber)(transactionSamples);
    }
  }], [isLoadingTransactions, observabilityShared.locators.apm.serviceOverview, observabilityShared.locators.apm.transactionDetailsByName, rangeFrom, rangeTo]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "profilingAPMTransactionsFieldText",
    value: filter,
    onChange: e => setFilter(e.target.value),
    isClearable: true,
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.profiling.apmTransactions.searchPlaceholder', {
      defaultMessage: 'Search services by name'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: isLoadingTransactions,
    tableCaption: _i18n.i18n.translate('xpack.profiling.apmTransactions.tableCaption', {
      defaultMessage: 'APM Services and Transactions links'
    }),
    items: transactionsPerServiceMap,
    columns: columns,
    pagination: {
      pageIndex,
      pageSize,
      totalItemCount,
      showPerPageOptions: false
    },
    sorting: {
      sort: {
        field: sortField,
        direction: sortDirection
      }
    },
    onChange: onTableChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 9
    }
  })));
}