"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RouteBreadcrumbsContext = void 0;
exports.RouteBreadcrumbsContextProvider = RouteBreadcrumbsContextProvider;
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/contexts/route_breadcrumbs_context/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RouteBreadcrumbsContext = exports.RouteBreadcrumbsContext = /*#__PURE__*/(0, _react.createContext)(undefined);
function RouteBreadcrumbsContextProvider({
  children
}) {
  const [, forceUpdate] = (0, _react.useState)({});
  const breadcrumbs = (0, _react.useMemo)(() => {
    return new Map();
  }, []);
  const matches = (0, _typedReactRouterConfig.useMatchRoutes)();
  const api = (0, _react.useMemo)(() => ({
    set(route, breadcrumb) {
      if (!(0, _lodash.isEqual)(breadcrumbs.get(route), breadcrumb)) {
        breadcrumbs.set(route, breadcrumb);
        forceUpdate({});
      }
    },
    unset(route) {
      if (breadcrumbs.has(route)) {
        breadcrumbs.delete(route);
        forceUpdate({});
      }
    },
    getBreadcrumbs(currentMatches) {
      return (0, _lodash.compact)(currentMatches.flatMap(match => {
        const breadcrumb = breadcrumbs.get(match.route);
        return breadcrumb;
      }));
    }
  }), [breadcrumbs]);
  const formattedBreadcrumbs = api.getBreadcrumbs(matches).map((breadcrumb, index, array) => {
    return {
      text: breadcrumb.title,
      ...(index === array.length - 1 ? {} : {
        href: breadcrumb.href
      })
    };
  });

  // Filter out the "Universal Profiling" breadcrumb because it is included in the breadcrumbs already in case of the project navigation
  const projectStyleBreadcrumbs = formattedBreadcrumbs.filter(breadcrumb => String(breadcrumb === null || breadcrumb === void 0 ? void 0 : breadcrumb.text).toLocaleLowerCase() !== 'universal profiling');
  (0, _public.useBreadcrumbs)(projectStyleBreadcrumbs, {
    absoluteProjectStyleBreadcrumbs: false,
    classicOnly: false
  });

  // Keep using breadcrumbs for the Profiling app for classic navigation
  (0, _public.useBreadcrumbs)(formattedBreadcrumbs, {
    classicOnly: true
  });
  return /*#__PURE__*/_react.default.createElement(RouteBreadcrumbsContext.Provider, {
    value: api,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  }, children);
}