"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.NOT_AVAILABLE_LABEL = exports.INDEX_TRACES = exports.INDEX_FRAMES = exports.INDEX_EXECUTABLES = exports.INDEX_EVENTS = void 0;
exports.getRoutePaths = getRoutePaths;
exports.timeRangeFromRequest = timeRangeFromRequest;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'profiling';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'profiling';
const INDEX_EVENTS = exports.INDEX_EVENTS = 'profiling-events-all';
const INDEX_TRACES = exports.INDEX_TRACES = 'profiling-stacktraces';
const INDEX_FRAMES = exports.INDEX_FRAMES = 'profiling-stackframes';
const INDEX_EXECUTABLES = exports.INDEX_EXECUTABLES = 'profiling-executables';
const BASE_ROUTE_PATH = '/internal/profiling';
const PUBLIC_BASE_ROUTE_PATH = '/api/profiling';
function getRoutePaths() {
  return {
    TopN: `${BASE_ROUTE_PATH}/topn`,
    TopNContainers: `${BASE_ROUTE_PATH}/topn/containers`,
    TopNDeployments: `${BASE_ROUTE_PATH}/topn/deployments`,
    TopNExecutables: `${BASE_ROUTE_PATH}/topn/executables`,
    TopNFunctions: `${BASE_ROUTE_PATH}/topn/functions`,
    TopNHosts: `${BASE_ROUTE_PATH}/topn/hosts`,
    TopNThreads: `${BASE_ROUTE_PATH}/topn/threads`,
    TopNTraces: `${BASE_ROUTE_PATH}/topn/traces`,
    APMTransactions: `${BASE_ROUTE_PATH}/topn/functions/apm/transactions`,
    Flamechart: `${BASE_ROUTE_PATH}/flamechart`,
    HasSetupESResources: `${PUBLIC_BASE_ROUTE_PATH}/setup/es_resources`,
    SetupDataCollectionInstructions: `${BASE_ROUTE_PATH}/setup/instructions`,
    StorageExplorerSummary: `${BASE_ROUTE_PATH}/storage_explorer/summary`,
    StorageExplorerHostStorageDetails: `${BASE_ROUTE_PATH}/storage_explorer/host_storage_details`,
    StorageExplorerIndicesStorageDetails: `${BASE_ROUTE_PATH}/storage_explorer/indices_storage_details`
  };
}
function timeRangeFromRequest(request) {
  const timeFrom = parseInt(request.query.timeFrom, 10);
  const timeTo = parseInt(request.query.timeTo, 10);
  return [timeFrom, timeTo];
}
const NOT_AVAILABLE_LABEL = exports.NOT_AVAILABLE_LABEL = _i18n.i18n.translate('xpack.profiling.notAvailableLabel', {
  defaultMessage: 'N/A'
});