"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("./utils");
var _perform_search = require("./perform_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SearchService {
  constructor({
    logger,
    esClient
  }) {
    (0, _defineProperty2.default)(this, "log", void 0);
    (0, _defineProperty2.default)(this, "esClient", void 0);
    this.log = logger;
    this.esClient = esClient;
  }
  async search(options) {
    const {
      query,
      max = 3,
      highlights = 3,
      products,
      inferenceId
    } = options;
    const index = (0, _utils.getIndicesForProductNames)(products, inferenceId);
    this.log.debug(`performing search - query=[${query}] at index=[${index}] `);
    const results = await (0, _perform_search.performSearch)({
      searchQuery: query,
      size: max,
      highlights,
      index,
      client: this.esClient
    });
    return {
      results: results.map(_utils.mapResult)
    };
  }
}
exports.SearchService = SearchService;