"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/saved-objects-plugin/public");
var _saved_object_save_modal_dashboard_selector = require("./saved_object_save_modal_dashboard_selector");
var _get_presentation_capabilities = require("../utils/get_presentation_capabilities");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/presentation_util/public/components/saved_object_save_modal_dashboard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SavedObjectSaveModalDashboard(props) {
  const {
    documentInfo,
    tagOptions,
    objectType,
    onClose,
    canSaveByReference
  } = props;
  const {
    id: documentId
  } = documentInfo;
  const initialCopyOnSave = !Boolean(documentId);
  const {
    canAccessDashboards,
    canCreateNewDashboards
  } = (0, _react.useMemo)(() => {
    return (0, _get_presentation_capabilities.getPresentationCapabilities)();
  }, []);

  // Disable the dashboard options if the user can't access dashboards or if they're read-only
  const disableDashboardOptions = !canAccessDashboards || !canCreateNewDashboards;
  const [dashboardOption, setDashboardOption] = (0, _react.useState)(documentId || disableDashboardOptions ? null : 'existing');
  const [isAddToLibrarySelected, setAddToLibrary] = (0, _react.useState)(canSaveByReference && (!initialCopyOnSave || disableDashboardOptions));
  const [selectedDashboard, setSelectedDashboard] = (0, _react.useState)(null);
  const [copyOnSave, setCopyOnSave] = (0, _react.useState)(initialCopyOnSave);
  const rightOptions = !disableDashboardOptions ? ({
    hasAttemptedSubmit
  }) => /*#__PURE__*/_react.default.createElement(_saved_object_save_modal_dashboard_selector.SaveModalDashboardSelector, {
    onSelectDashboard: dash => {
      setSelectedDashboard(dash);
    },
    onChange: option => {
      setDashboardOption(option);
    },
    canSaveByReference: canSaveByReference,
    copyOnSave,
    documentId,
    dashboardOption,
    setAddToLibrary,
    isAddToLibrarySelected,
    hasAttemptedSubmit,
    hasSelectedDashboard: Boolean(selectedDashboard),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }) : null;
  const onCopyOnSaveChange = newCopyOnSave => {
    if (canSaveByReference) {
      setAddToLibrary(true);
    }
    setDashboardOption(null);
    setCopyOnSave(newCopyOnSave);
  };
  const onModalSave = async onSaveProps => {
    let dashboardId = null;

    // Don't save with a dashboard ID if we're
    // just updating an existing visualization
    if (!(!onSaveProps.newCopyOnSave && documentId)) {
      if (dashboardOption === 'existing') {
        dashboardId = (selectedDashboard === null || selectedDashboard === void 0 ? void 0 : selectedDashboard.id) || null;
      } else {
        dashboardId = dashboardOption;
      }
    }
    await props.onSave({
      ...onSaveProps,
      dashboardId,
      addToLibrary: isAddToLibrarySelected
    });
  };
  const saveLibraryLabel = !copyOnSave && documentId ? _i18n.i18n.translate('presentationUtil.saveModalDashboard.saveLabel', {
    defaultMessage: 'Save'
  }) : _i18n.i18n.translate('presentationUtil.saveModalDashboard.saveToLibraryLabel', {
    defaultMessage: 'Save and add to library'
  });
  const saveDashboardLabel = _i18n.i18n.translate('presentationUtil.saveModalDashboard.saveAndGoToDashboardLabel', {
    defaultMessage: 'Save and go to Dashboard'
  });
  const confirmButtonLabel = dashboardOption === null ? saveLibraryLabel : saveDashboardLabel;
  const isValid = !(dashboardOption === 'existing' && selectedDashboard === null);
  return /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModal, {
    onSave: onModalSave,
    title: documentInfo.title,
    showCopyOnSave: documentId ? true : false,
    options: isAddToLibrarySelected ? tagOptions : undefined // Show tags when not adding to dashboard
    ,
    description: documentInfo.description,
    showDescription: true,
    mustCopyOnSaveMessage: props.mustCopyOnSaveMessage,
    confirmButtonLabel,
    initialCopyOnSave,
    isValid,
    objectType,
    onClose,
    onCopyOnSaveChange,
    rightOptions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  });
}

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
var _default = exports.default = SavedObjectSaveModalDashboard;
module.exports = exports.default;