"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _codeEditor = require("@kbn/code-editor");
var _common = require("../../../common");
var _constants = require("./constants");
var _providers = require("./providers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/presentation_util/public/components/expression_input/expression_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * An input component that can provide suggestions and hover information for an Expression
 * as it is being written.  Be certain to provide ExpressionFunctions by calling `registerExpressionFunctions`
 * from the start contract of the presentationUtil plugin.
 */
const ExpressionInput = props => {
  const {
    expressionFunctions,
    expression: initialExpression,
    onChange: onChangeProp,
    isCompact,
    height,
    style,
    editorRef,
    onEditorDidMount,
    ...rest
  } = props;
  const [expression, setExpression] = (0, _react.useState)(initialExpression);
  const prevExpression = (0, _usePrevious.default)(initialExpression);
  (0, _react.useEffect)(() => {
    if (prevExpression !== initialExpression) {
      setExpression(initialExpression);
    }
  }, [prevExpression, initialExpression]);
  const suggestionProvider = (0, _react.useMemo)(() => (0, _providers.getSuggestionProvider)(expressionFunctions), [expressionFunctions]);
  const hoverProvider = (0, _react.useMemo)(() => (0, _providers.getHoverProvider)(expressionFunctions), [expressionFunctions]);

  // Updating tab size for the editor
  const editorDidMount = editor => {
    const model = editor.getModel();
    model === null || model === void 0 ? void 0 : model.updateOptions({
      tabSize: 2
    });
    onEditorDidMount === null || onEditorDidMount === void 0 ? void 0 : onEditorDidMount(editor);
    if (editorRef) {
      editorRef.current = editor;
    }
  };
  const setValue = (0, _lodash.debounce)(value => setExpression(value), 500, {
    leading: true,
    trailing: false
  });
  const onChange = value => {
    setValue(value);
    onChangeProp(value);
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height,
      ...style
    },
    rest,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: _common.EXPRESSIONS_LANGUAGE_ID,
    languageConfiguration: _constants.LANGUAGE_CONFIGURATION,
    value: expression,
    onChange: onChange,
    suggestionProvider: suggestionProvider,
    hoverProvider: hoverProvider,
    options: {
      ..._constants.CODE_EDITOR_OPTIONS,
      fontSize: isCompact ? 12 : 16
    },
    editorDidMount: editorDidMount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }));
};
exports.ExpressionInput = ExpressionInput;