"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.OsqueryActionResult = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _reactQuery = require("@kbn/react-query");
var _empty_prompt = require("../../routes/components/empty_prompt");
var _kibana = require("../../common/lib/kibana");
var _query_client = require("../../query_client");
var _contexts = require("../../common/contexts");
var _pack_queries_status_table = require("../../live_queries/form/pack_queries_status_table");
var _translations = require("../../agents/translations");
var _use_live_query_details = require("../../actions/use_live_query_details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/shared_components/osquery_results/osquery_result_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line react/display-name
const OsqueryResultComponent = /*#__PURE__*/_react.default.memo(({
  actionId,
  ruleName,
  startDate,
  ecsData
}) => {
  const {
    read
  } = (0, _kibana.useKibana)().services.application.capabilities.osquery;
  const [isLive, setIsLive] = (0, _react.useState)(false);
  const {
    data
  } = (0, _use_live_query_details.useLiveQueryDetails)({
    actionId,
    isLive,
    skip: !read
  });
  (0, _react.useEffect)(() => {
    setIsLive(() => !((data === null || data === void 0 ? void 0 : data.status) === 'completed'));
  }, [data === null || data === void 0 ? void 0 : data.status]);
  return /*#__PURE__*/_react.default.createElement(_contexts.AlertAttachmentContext.Provider, {
    value: ecsData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
    username: ruleName,
    timestamp: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
      value: startDate,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 22
      }
    }),
    event: _translations.ATTACHED_QUERY,
    "data-test-subj": 'osquery-results-comment',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, !read ? /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_pack_queries_status_table.PackQueriesStatusTable, {
    actionId: actionId,
    data: data === null || data === void 0 ? void 0 : data.queries,
    startDate: data === null || data === void 0 ? void 0 : data['@timestamp'],
    expirationDate: data === null || data === void 0 ? void 0 : data.expiration,
    agentIds: data === null || data === void 0 ? void 0 : data.agents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  })));
});
const OsqueryActionResult = exports.OsqueryActionResult = /*#__PURE__*/_react.default.memo(OsqueryResultComponent);
const OsqueryActionResultWrapperComponent = ({
  services,
  ...restProps
}) => /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, services, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 3
  }
}), /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
  services: services,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 77,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
  client: _query_client.queryClient,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 78,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(OsqueryActionResult, (0, _extends2.default)({}, restProps, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 79,
    columnNumber: 9
  }
})))));
const OsqueryActionResultWrapper = exports.default = /*#__PURE__*/_react.default.memo(OsqueryActionResultWrapperComponent);

// eslint-disable-next-line import/no-default-export