"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateConfig = void 0;
var _esqlValidationAutocomplete = require("@kbn/esql-validation-autocomplete");
var _onechatCommon = require("@kbn/onechat-common");
var _esqlUtils = require("@kbn/esql-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateConfig = async configuration => {
  // Ensure query is proper ES|QL syntax
  const validationResult = await (0, _esqlValidationAutocomplete.validateQuery)(configuration.query, {
    ignoreOnMissingCallbacks: true
  });
  if (validationResult.errors.length > 0) {
    const message = `Validation error: \n${validationResult.errors.map(error => 'text' in error ? error.text : '').join('\n')}`;
    throw (0, _onechatCommon.createBadRequestError)(message);
  }

  // Check for parameter mismatches
  const queryParams = (0, _esqlUtils.getESQLQueryVariables)(configuration.query);
  const definedParams = Object.keys(configuration.params);
  const undefinedParams = queryParams.filter(param => !definedParams.includes(param));
  if (undefinedParams.length > 0) {
    throw (0, _onechatCommon.createBadRequestError)(`Query uses undefined parameters: ${undefinedParams.join(', ')}\n` + `Available parameters: ${definedParams.join(', ') || 'none'}`);
  }
  const unusedParams = definedParams.filter(param => !queryParams.includes(param));
  if (unusedParams.length > 0) {
    throw (0, _onechatCommon.createBadRequestError)(`Defined parameters not used in query: ${unusedParams.join(', ')}\n` + `Query parameters: ${queryParams.join(', ') || 'none'}`);
  }
};
exports.validateConfig = validateConfig;