"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createHandler = void 0;
var _utils = require("@kbn/onechat-genai-utils/tools/utils");
var _onechatCommon = require("@kbn/onechat-common");
var _tools = require("@kbn/onechat-server/tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createHandler = configuration => {
  return async (params, {
    esClient
  }) => {
    const client = esClient.asCurrentUser;
    const paramArray = Object.keys(configuration.params).map(param => {
      var _params$param;
      return {
        [param]: (_params$param = params[param]) !== null && _params$param !== void 0 ? _params$param : null
      };
    });
    const result = await client.esql.query({
      query: configuration.query,
      // TODO: wait until client is fixed: https://github.com/elastic/elasticsearch-specification/issues/5083
      params: paramArray
    });

    // need the interpolated query to return in the results / to display in the UI
    const interpolatedQuery = (0, _utils.interpolateEsqlQuery)(configuration.query, params);
    return {
      results: [{
        type: _onechatCommon.ToolResultType.query,
        data: {
          esql: interpolatedQuery
        }
      }, {
        tool_result_id: (0, _tools.getToolResultId)(),
        type: _onechatCommon.ToolResultType.tabularData,
        data: {
          source: 'esql',
          query: interpolatedQuery,
          columns: result.columns,
          values: result.values
        }
      }]
    };
  };
};
exports.createHandler = createHandler;