"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatDate = exports.customInstructionsBlock = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const customInstructionsBlock = instructions => {
  if (!instructions) {
    return '';
  }
  return `### User instructions

  Below are specific instructions provided by the end user, that you should follow when relevant, as
  long as they don't conflict with your defined task or contradict your primary instructions.

  Instruction: "${instructions}"`;
};
exports.customInstructionsBlock = customInstructionsBlock;
const formatDate = (date = new Date()) => {
  return (0, _moment.default)(date).format('YYYY/MM/DD HH:mm');
};
exports.formatDate = formatDate;