"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AgentService {
  constructor({
    http
  }) {
    (0, _defineProperty2.default)(this, "http", void 0);
    this.http = http;
  }

  /**
   * List all agents
   */
  async list(options) {
    const res = await this.http.get(`${_constants.publicApiPath}/agents`);
    return res.results;
  }

  /**
   * Get a single agent by id
   */
  async get(id) {
    return await this.http.get(`${_constants.publicApiPath}/agents/${id}`);
  }

  /**
   * Create a new agent
   */
  async create(profile) {
    return await this.http.post(`${_constants.publicApiPath}/agents`, {
      body: JSON.stringify(profile)
    });
  }

  /**
   * Update an existing agent
   */
  async update(id, update) {
    return await this.http.put(`${_constants.publicApiPath}/agents/${id}`, {
      body: JSON.stringify(update)
    });
  }

  /**
   * Delete an agent by id
   */
  async delete(id) {
    return await this.http.delete(`${_constants.publicApiPath}/agents/${id}`);
  }
}
exports.AgentService = AgentService;