"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BottomBarActions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/management/components/bottom_bar_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const BottomBarActions = ({
  isLoading,
  onSave,
  onDiscardChanges,
  unsavedChangesCount,
  areChangesInvalid
}) => {
  if (unsavedChangesCount === 0) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, {
    paddingSize: "s",
    position: "fixed",
    "aria-label": _i18n.i18n.translate('xpack.onechat.management.bottomBar.ariaLabel', {
      defaultMessage: 'Settings actions'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    "aria-live": "polite",
    "aria-atomic": "true",
    "data-test-subj": "unsavedChangesCount",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.onechat.management.bottomBar.unsavedChangesCount', {
    defaultMessage: '{count, plural, one {# change} other {# changes}}',
    values: {
      count: unsavedChangesCount
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "text",
    onClick: onDiscardChanges,
    "data-test-subj": "agentBuilderDiscard",
    "aria-label": _i18n.i18n.translate('xpack.onechat.management.bottomBar.discardAria', {
      defaultMessage: 'Discard unsaved changes'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.onechat.management.bottomBar.discard', {
    defaultMessage: 'Discard'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isLoading: isLoading,
    isDisabled: !!areChangesInvalid,
    onClick: onSave,
    "data-test-subj": "agentBuilderSave",
    "aria-label": _i18n.i18n.translate('xpack.onechat.management.bottomBar.saveAria', {
      defaultMessage: 'Save changes'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.onechat.management.bottomBar.save', {
    defaultMessage: 'Save changes'
  })))))));
};
exports.BottomBarActions = BottomBarActions;