"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUiPrivileges = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _features = require("../../../common/features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUiPrivileges = () => {
  const {
    services: {
      application
    }
  } = (0, _public.useKibana)();
  const onechatCapabilities = (0, _react.useMemo)(() => {
    var _application$capabili, _application$capabili2;
    const capabilities = (_application$capabili = application === null || application === void 0 ? void 0 : (_application$capabili2 = application.capabilities) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2[_features.ONECHAT_FEATURE_ID]) !== null && _application$capabili !== void 0 ? _application$capabili : {};
    return Object.keys(_features.uiPrivileges).reduce((acc, key) => {
      const privilegeKey = key;
      acc[privilegeKey] = !!capabilities[_features.uiPrivileges[privilegeKey]];
      return acc;
    }, {});
  }, [application]);
  return onechatCapabilities;
};
exports.useUiPrivileges = useUiPrivileges;