"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConversationId = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _new_conversation = require("../utils/new_conversation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useConversationId = () => {
  const {
    conversationId: conversationIdParam
  } = (0, _reactRouterDom.useParams)();
  const conversationId = (0, _react.useMemo)(() => {
    return conversationIdParam === _new_conversation.newConversationId ? undefined : conversationIdParam;
  }, [conversationIdParam]);
  return conversationId;
};
exports.useConversationId = useConversationId;