"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePendingMessageState = void 0;
var _immer = _interopRequireDefault(require("immer"));
var _react = require("react");
var _new_conversation = require("../../utils/new_conversation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePendingMessageState = ({
  conversationId
}) => {
  var _conversationIdToPend;
  const [conversationIdToPendingMessageState, setConversationIdToPendingMessageState] = (0, _react.useState)({});
  const id = conversationId !== null && conversationId !== void 0 ? conversationId : _new_conversation.newConversationId;
  const updateState = updater => {
    setConversationIdToPendingMessageState((0, _immer.default)(draft => {
      draft[id] ??= {};
      updater(draft[id]);
    }));
  };
  const pendingMessageState = (_conversationIdToPend = conversationIdToPendingMessageState[id]) !== null && _conversationIdToPend !== void 0 ? _conversationIdToPend : {};
  return {
    pendingMessageState,
    setPendingMessage: pendingMessage => {
      updateState(state => {
        state.pendingMessage = pendingMessage;
      });
    },
    removePendingMessage: () => {
      updateState(state => {
        delete state.pendingMessage;
      });
    },
    setError: error => {
      updateState(state => {
        state.error = error;
      });
    },
    removeError: () => {
      updateState(state => {
        delete state.error;
      });
    }
  };
};
exports.usePendingMessageState = usePendingMessageState;