"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationSidebarNav = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = _interopRequireDefault(require("react"));
var _use_navigation = require("../../../hooks/use_navigation");
var _app_paths = require("../../../utils/app_paths");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_sidebar/conversation_sidebar_nav.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConversationSidebarNav = () => {
  const {
    createOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const agentsHref = createOnechatUrl(_app_paths.appPaths.agents.list);
  const toolsHref = createOnechatUrl(_app_paths.appPaths.tools.list);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const containerStyles = (0, _react.css)`
    border-top: 1px solid ${euiTheme.border.color};
    padding: ${euiTheme.size.m} ${euiTheme.size.base};
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiListGroup, {
    css: containerStyles,
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiListGroupItem, {
    color: "text",
    size: "s",
    href: agentsHref,
    iconType: "spaces",
    label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.conversationSidebar.navigation.agents",
      defaultMessage: "Agents",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiListGroupItem, {
    color: "text",
    size: "s",
    href: toolsHref,
    iconType: "wrench",
    label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.conversationSidebar.navigation.tools",
      defaultMessage: "Tools",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }));
};
exports.ConversationSidebarNav = ConversationSidebarNav;