"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = LoadWhenInView;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _useIntersection = _interopRequireDefault(require("react-use/lib/useIntersection"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_shared/public/components/load_when_in_view/load_when_in_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line import/no-default-export
function LoadWhenInView({
  children,
  placeholderTitle,
  initialHeight = 100
}) {
  const intersectionRef = _react.default.useRef(null);
  const intersection = (0, _useIntersection.default)(intersectionRef, {
    root: null,
    rootMargin: '0px',
    threshold: 0.25
  });
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (intersection && intersection.intersectionRatio > 0.25) {
      setIsVisible(true);
    }
  }, [intersection, intersection === null || intersection === void 0 ? void 0 : intersection.intersectionRatio]);
  return isVisible ? children : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "renderOnlyInViewPlaceholderContainer",
    ref: intersectionRef,
    role: "region",
    "aria-label": placeholderTitle,
    style: {
      height: initialHeight
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }));
}
module.exports = exports.default;