"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeZone = getTimeZone;
var _use_kibana_ui_settings = require("../hooks/use_kibana_ui_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTimeZone(uiSettings) {
  const kibanaTimeZone = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get(_use_kibana_ui_settings.UI_SETTINGS.DATEFORMAT_TZ);
  if (!kibanaTimeZone || kibanaTimeZone === 'Browser') {
    return 'local';
  }
  return kibanaTimeZone;
}