"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LandingPage = LandingPage;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/logs-shared-plugin/common");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _common2 = require("../../../common");
var _use_has_data = require("../../hooks/use_has_data");
var _kibana_react = require("../../utils/kibana_react");
var _get_apm_app_url = require("../../components/alert_sources/get_apm_app_url");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/landing/landing.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function LandingPage() {
  const {
    pricing
  } = (0, _kibana_react.useKibana)().services;
  const hasCompleteLandingPage = pricing.isFeatureAvailable(_common2.OBSERVABILITY_COMPLETE_LANDING_PAGE_FEATURE.id);
  return hasCompleteLandingPage ? /*#__PURE__*/_react.default.createElement(ObservabilityCompleteLandingPage, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(ObservabilityLogsEssentialsLandingPage, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  });
}
function ObservabilityCompleteLandingPage() {
  const {
    hasDataMap,
    isAllRequestsComplete
  } = (0, _use_has_data.useHasData)();
  const {
    share,
    logsDataAccess
  } = (0, _kibana_react.useKibana)().services;
  (0, _react.useEffect)(() => {
    async function redirectToLanding() {
      if (isAllRequestsComplete) {
        var _hasDataMap$apm;
        const {
          hasData: hasLogsData
        } = await logsDataAccess.services.logDataService.getStatus();
        const hasApmData = (_hasDataMap$apm = hasDataMap.apm) === null || _hasDataMap$apm === void 0 ? void 0 : _hasDataMap$apm.hasData;
        const locators = getLocators(share);
        if (hasLogsData && locators.logs) {
          locators.logs.navigate({});
        } else if (hasApmData && locators.apm) {
          locators.apm.navigate({});
        } else if (locators.onboarding) {
          locators.onboarding.navigate({});
        }
      }
    }
    redirectToLanding();
  }, [hasDataMap, isAllRequestsComplete, logsDataAccess, share]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
}
function ObservabilityLogsEssentialsLandingPage() {
  const {
    share,
    logsDataAccess
  } = (0, _kibana_react.useKibana)().services;
  (0, _react.useEffect)(() => {
    async function redirectToLanding() {
      const {
        hasData: hasLogsData
      } = await logsDataAccess.services.logDataService.getStatus();
      const locators = getLocators(share);
      if (hasLogsData && locators.logs) {
        locators.logs.navigate({});
      } else if (locators.onboarding) {
        locators.onboarding.navigate({});
      }
    }
    redirectToLanding();
  }, [logsDataAccess.services.logDataService, share]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
}
const getLocators = share => ({
  apm: share.url.locators.get(_get_apm_app_url.APM_APP_LOCATOR_ID),
  logs: share.url.locators.get(_common.LOGS_LOCATOR_ID),
  onboarding: share.url.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR)
});