"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _public = require("@kbn/observability-shared-plugin/public");
var _kibana_react = require("../../../utils/kibana_react");
var _use_bulk_untrack_alerts = require("../hooks/use_bulk_untrack_alerts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/alert_details/components/stale_alert.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function StaleAlert({
  alert,
  alertStatus,
  rule,
  refetchRule,
  onUntrackAlert
}) {
  const {
    services
  } = (0, _kibana_react.useKibana)();
  const {
    triggersActionsUi: {
      ruleTypeRegistry,
      actionTypeRegistry
    }
  } = services;
  const [ruleConditionsFlyoutOpen, setRuleConditionsFlyoutOpen] = (0, _react.useState)(false);
  const {
    mutateAsync: untrackAlerts
  } = (0, _use_bulk_untrack_alerts.useBulkUntrackAlerts)();
  const trackEvent = (0, _public.useUiTracker)();
  const handleUntrackAlert = (0, _react.useCallback)(async () => {
    const alertUuid = alert === null || alert === void 0 ? void 0 : alert.fields[_ruleDataUtils.ALERT_UUID];
    if (alertUuid) {
      await untrackAlerts({
        indices: ['.internal.alerts-observability.*'],
        alertUuids: [alertUuid]
      });
      onUntrackAlert();
    }
  }, [alert === null || alert === void 0 ? void 0 : alert.fields, untrackAlerts, onUntrackAlert]);
  const handleEditRuleDetails = () => {
    setRuleConditionsFlyoutOpen(true);
  };
  const isAlertStale = (0, _react.useMemo)(() => {
    if (alertStatus === _ruleDataUtils.ALERT_STATUS_ACTIVE) {
      var _alert$fields$ALERT_C;
      const numOfCases = ((_alert$fields$ALERT_C = alert.fields[_ruleDataUtils.ALERT_CASE_IDS]) === null || _alert$fields$ALERT_C === void 0 ? void 0 : _alert$fields$ALERT_C.length) || 0;
      const timestamp = alert.start;
      const givenDate = (0, _moment.default)(timestamp);
      const now = (0, _moment.default)();
      const diffInDays = now.diff(givenDate, 'days');

      // The heuristics to show the stale alert callout are:
      // 1. The alert has been active for more than 5 days

      if (diffInDays >= 5) {
        trackEvent({
          app: 'alerts',
          metricType: _public.METRIC_TYPE.LOADED,
          metric: `alert_details_alert_stale_callout__ruleType_${rule === null || rule === void 0 ? void 0 : rule.ruleTypeId}`
        });
        return {
          isStale: true,
          days: diffInDays,
          cases: numOfCases
        };
      }
    } else {
      return {
        isStale: false,
        days: 0,
        cases: 0
      };
    }
  }, [alert.fields, alert.start, alertStatus, rule === null || rule === void 0 ? void 0 : rule.ruleTypeId, trackEvent]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (isAlertStale === null || isAlertStale === void 0 ? void 0 : isAlertStale.isStale) && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "o11yAlertDetailsAlertStaleCallout",
    title: _i18n.i18n.translate('xpack.observability.alertDetails.staleAlertCallout.title', {
      defaultMessage: 'This alert may be stale'
    }),
    color: "warning",
    iconType: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.observability.alertDetails.staleAlertCallout.message', {
    defaultMessage: 'This alert has been active for {numOfDays} days and is assigned to {numOfCases} {cases}.',
    values: {
      numOfDays: isAlertStale === null || isAlertStale === void 0 ? void 0 : isAlertStale.days,
      numOfCases: isAlertStale === null || isAlertStale === void 0 ? void 0 : isAlertStale.cases,
      cases: (isAlertStale === null || isAlertStale === void 0 ? void 0 : isAlertStale.cases) > 1 ? 'cases' : 'case'
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexStart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yAlertDetailsAlertStaleCalloutMarkAsUntrackedButton",
    color: "warning",
    fill: true,
    iconType: "eyeClosed",
    onClick: handleUntrackAlert,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.observability.alertDetails.alertStaleCallout.markAsUntrackedButton', {
    defaultMessage: 'Untrack'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yAlertDetailsAlertStaleCalloutEditRule",
    color: "warning",
    iconType: "pencil",
    onClick: handleEditRuleDetails,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.observability.alertDetails.alertStaleCallout.editRuleButton', {
    defaultMessage: 'Edit rule'
  })))), rule && ruleConditionsFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
    plugins: {
      ...services,
      ruleTypeRegistry,
      actionTypeRegistry
    },
    id: rule.id,
    onCancel: () => {
      setRuleConditionsFlyoutOpen(false);
    },
    onSubmit: () => {
      setRuleConditionsFlyoutOpen(false);
      refetchRule();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }) : null);
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = StaleAlert;
module.exports = exports.default;