"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AlertDetailsAppSection;
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _observabilityGetPaddedAlertTimeRangeUtil = require("@kbn/observability-get-padded-alert-time-range-util");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _moment = _interopRequireDefault(require("moment"));
var _get_group = require("../../../../../common/custom_threshold_rule/helpers/get_group");
var _kibana_react = require("../../../../utils/kibana_react");
var _metric_value_formatter = require("../../../../../common/custom_threshold_rule/metric_value_formatter");
var _threshold = require("../threshold");
var _log_rate_analysis = require("./log_rate_analysis");
var _rule_condition_chart = require("../../../rule_condition_chart/rule_condition_chart");
var _generate_chart_title_and_tooltip = require("./helpers/generate_chart_title_and_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/custom_threshold/components/alert_details_app_section/alert_details_app_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line import/no-default-export
function AlertDetailsAppSection({
  alert
}) {
  var _application$capabili, _application$capabili2;
  const services = (0, _kibana_react.useKibana)().services;
  const {
    charts,
    data,
    application
  } = services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const aiopsEnabled = (_application$capabili = (_application$capabili2 = application.capabilities.aiops) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.enabled) !== null && _application$capabili !== void 0 ? _application$capabili : false;
  const [dataView, setDataView] = (0, _react.useState)();
  const [, setDataViewError] = (0, _react.useState)();
  const [timeRange, setTimeRange] = (0, _react.useState)({
    from: 'now-15m',
    to: 'now'
  });
  const chartProps = {
    baseTheme: charts.theme.useChartsBaseTheme()
  };
  const ruleParams = alert.fields[_ruleDataUtils.ALERT_RULE_PARAMETERS];
  const alertStart = alert.fields[_ruleDataUtils.ALERT_START];
  const alertEnd = alert.fields[_ruleDataUtils.ALERT_END];
  const groups = alert.fields[_ruleDataUtils.ALERT_GROUP];
  const chartTitleAndTooltip = [];
  ruleParams.criteria.forEach(criterion => {
    chartTitleAndTooltip.push((0, _generate_chart_title_and_tooltip.generateChartTitleAndTooltip)(criterion));
  });
  const alertStartAnnotation = {
    label: 'Alert',
    type: 'manual',
    key: {
      type: 'point_in_time',
      timestamp: alertStart
    },
    color: euiTheme.colors.danger,
    icon: 'alert',
    id: 'custom_threshold_alert_start_annotation'
  };
  const alertRangeAnnotation = {
    label: `${alertEnd ? 'Alert duration' : 'Active alert'}`,
    type: 'manual',
    key: {
      type: 'range',
      timestamp: alertStart,
      endTimestamp: alertEnd !== null && alertEnd !== void 0 ? alertEnd : (0, _moment.default)().toISOString()
    },
    color: (0, _chromaJs.default)((0, _eui.transparentize)('#F04E981A', 0.2)).hex().toUpperCase(),
    id: `custom_threshold_${alertEnd ? 'recovered' : 'active'}_alert_range_annotation`
  };
  const annotations = [];
  annotations.push(alertStartAnnotation, alertRangeAnnotation);
  (0, _react.useEffect)(() => {
    setTimeRange((0, _observabilityGetPaddedAlertTimeRangeUtil.getPaddedAlertTimeRange)(alertStart, alertEnd));
  }, [alertStart, alertEnd]);
  (0, _react.useEffect)(() => {
    const initDataView = async () => {
      const ruleSearchConfiguration = ruleParams.searchConfiguration;
      try {
        const createdSearchSource = await data.search.searchSource.create(ruleSearchConfiguration);
        setDataView(createdSearchSource.getField('index'));
      } catch (error) {
        setDataViewError(error);
      }
    };
    initDataView();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [data.search.searchSource]);
  if (!ruleParams.criteria) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "thresholdAlertOverviewSection",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  }, ruleParams.criteria.map((criterion, index) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `criterion-${index}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      hasShadow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: chartTitleAndTooltip[index].tooltip,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      "data-test-subj": `chartTitle-${index}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 23
      }
    }, chartTitleAndTooltip[index].title))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: {
        minHeight: 150,
        minWidth: 160
      },
      grow: 1,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_threshold.Threshold, {
      chartProps: chartProps,
      id: `threshold-${index}`,
      threshold: criterion.threshold,
      value: alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUES][index],
      valueFormatter: d => (0, _metric_value_formatter.metricValueFormatter)(d, criterion.metrics[0] ? criterion.metrics[0].name : undefined),
      title: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertDetailsAppSection.thresholdTitle', {
        defaultMessage: 'Threshold breached'
      }),
      comparator: criterion.comparator,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 5,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_rule_condition_chart.RuleConditionChart, {
      additionalFilters: (0, _get_group.getGroupFilters)(groups),
      annotations: annotations,
      chartOptions: {
        // For alert details page, the series type needs to be changed to 'bar_stacked'
        // due to https://github.com/elastic/elastic-charts/issues/2323
        seriesType: 'bar_stacked'
      },
      dataView: dataView,
      groupBy: ruleParams.groupBy,
      metricExpression: criterion,
      searchConfiguration: ruleParams.searchConfiguration,
      timeRange: timeRange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 19
      }
    })))));
  }), aiopsEnabled && /*#__PURE__*/_react.default.createElement(_log_rate_analysis.LogRateAnalysis, {
    alert: alert,
    dataView: dataView,
    services: services,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 24
    }
  }));
}
module.exports = exports.default;