"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderGroupPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _src = require("@kbn/grouping/src");
var _i18nReact = require("@kbn/i18n-react");
var _tags = require("../../tags");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/alerts_table/grouping/render_group_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const renderGroupPanel = (selectedGroup, bucket) => {
  var _bucket$ruleTags;
  switch (selectedGroup) {
    case 'kibana.alert.rule.name':
      return (0, _fp.isArray)(bucket.key) ? /*#__PURE__*/_react.default.createElement(RuleNameGroupContent, {
        ruleName: bucket.key[0],
        tags: (_bucket$ruleTags = bucket.ruleTags) === null || _bucket$ruleTags === void 0 ? void 0 : _bucket$ruleTags.buckets.map(tag => tag.key),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 25,
          columnNumber: 9
        }
      }) : undefined;
    case 'kibana.alert.instance.id':
      return /*#__PURE__*/_react.default.createElement(InstanceIdGroupContent, {
        instanceId: (0, _src.firstNonNullValue)(bucket.key),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 31,
          columnNumber: 14
        }
      });
  }
};
exports.renderGroupPanel = renderGroupPanel;
const RuleNameGroupContent = /*#__PURE__*/_react.default.memo(({
  ruleName,
  tags
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'table',
      tableLayout: 'fixed',
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "rule-name-group-renderer",
    gutterSize: "m",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      display: 'contents'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    className: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 13
    }
  }, ruleName)))), !!tags && tags.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_tags.Tags, {
    tags: tags,
    color: "hollow",
    size: 5,
    oneLine: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  })));
});
RuleNameGroupContent.displayName = 'RuleNameGroup';
const InstanceIdGroupContent = /*#__PURE__*/_react.default.memo(({
  instanceId
}) => {
  const isUngrouped = instanceId === '*';
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'table',
      tableLayout: 'fixed',
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "rule-name-group-renderer",
    gutterSize: "m",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      display: 'contents'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    className: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, isUngrouped ? _constants.ungrouped : instanceId !== null && instanceId !== void 0 ? instanceId : '--', "\xA0", isUngrouped && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.alert.grouping.ungrouped.info",
      defaultMessage: "There is no \"group by\" field selected in the rule definition.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 17
    }
  }))))));
});
InstanceIdGroupContent.displayName = 'InstanceIdGroupContent';