"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertActions = AlertActions;
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/observability-shared-plugin/common");
var _default_alert_actions = require("@kbn/response-ops-alerts-table/components/default_alert_actions");
var _use_case_actions = require("./use_case_actions");
var _constants = require("../../pages/rule_details/constants");
var _paths = require("../../../common/locators/paths");
var _parse_alert = require("../../pages/alerts/helpers/parse_alert");
var _ = require("../..");
var _alert_details = require("../../pages/alert_details/alert_details");
var _kibana_react = require("../../utils/kibana_react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/alert_actions/alert_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AlertActions(props) {
  const {
    observabilityRuleTypeRegistry,
    alert,
    tableId,
    refresh,
    parentAlert,
    rowIndex,
    onExpandedAlertIndexChange,
    services
  } = props;
  const {
    http: {
      basePath: {
        prepend
      }
    },
    cases
  } = services;
  const isSLODetailsPage = (0, _reactRouterDom.useRouteMatch)(_paths.SLO_DETAIL_PATH);
  const {
    telemetryClient
  } = (0, _kibana_react.useKibana)().services;
  const isInApp = Boolean(tableId === _common.SLO_ALERTS_TABLE_ID && isSLODetailsPage);
  const userCasesPermissions = cases === null || cases === void 0 ? void 0 : cases.helpers.canUseCases([_.observabilityFeatureId]);
  const [viewInAppUrl, setViewInAppUrl] = (0, _react.useState)();
  const parseObservabilityAlert = (0, _react.useMemo)(() => (0, _parse_alert.parseAlert)(observabilityRuleTypeRegistry), [observabilityRuleTypeRegistry]);
  const observabilityAlert = parseObservabilityAlert(alert);
  (0, _react.useEffect)(() => {
    const alertLink = observabilityAlert.link;
    if (!observabilityAlert.hasBasePath && prepend) {
      setViewInAppUrl(prepend(alertLink !== null && alertLink !== void 0 ? alertLink : ''));
    } else {
      setViewInAppUrl(alertLink);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const handleViewInAppUrl = (0, _react.useCallback)(() => {
    const alertLink = observabilityAlert.link;
    if (!observabilityAlert.hasBasePath) {
      setViewInAppUrl(prepend(alertLink !== null && alertLink !== void 0 ? alertLink : ''));
    } else {
      setViewInAppUrl(alertLink);
    }
  }, [observabilityAlert.link, observabilityAlert.hasBasePath, prepend]);
  const onAddToCase = (0, _react.useCallback)(({
    isNewCase
  }) => {
    telemetryClient.reportAlertAddedToCase(isNewCase, tableId || 'unknown', observabilityAlert.fields['kibana.alert.rule.rule_type_id']);
    refresh === null || refresh === void 0 ? void 0 : refresh();
  }, [telemetryClient, tableId, observabilityAlert.fields, refresh]);
  const {
    isPopoverOpen,
    setIsPopoverOpen,
    handleAddToExistingCaseClick,
    handleAddToNewCaseClick
  } = (0, _use_case_actions.useCaseActions)({
    onAddToCase,
    alerts: [alert],
    services: {
      cases
    }
  });
  const closeActionsPopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);
  const toggleActionsPopover = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const actionsMenuItems = [...(userCasesPermissions !== null && userCasesPermissions !== void 0 && userCasesPermissions.createComment && userCasesPermissions !== null && userCasesPermissions !== void 0 && userCasesPermissions.read ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "add-to-existing-case-action",
    key: "addToExistingCase",
    onClick: handleAddToExistingCaseClick,
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.observability.alerts.actions.addToCase', {
    defaultMessage: 'Add to existing case'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "add-to-new-case-action",
    key: "addToNewCase",
    onClick: handleAddToNewCaseClick,
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.observability.alerts.actions.addToNewCase', {
    defaultMessage: 'Add to new case'
  }))] : []), (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_default_alert_actions.DefaultAlertActions, (0, _extends2.default)({}, props, {
    key: "defaultRowActions",
    onActionExecuted: closeActionsPopover,
    isAlertDetailsEnabled: true,
    resolveRulePagePath: (ruleId, currentPageId) => currentPageId !== _constants.RULE_DETAILS_PAGE_ID ? _paths.paths.observability.ruleDetails(ruleId) : null,
    resolveAlertPagePath: (alertId, currentPageId) => currentPageId !== _alert_details.ALERT_DETAILS_PAGE_ID ? _paths.paths.observability.alertDetails(alertId) : null,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  })), [closeActionsPopover, props])];
  const actionsToolTip = actionsMenuItems.length <= 0 ? _i18n.i18n.translate('xpack.observability.alertsTable.notEnoughPermissions', {
    defaultMessage: 'Additional privileges required'
  }) : _i18n.i18n.translate('xpack.observability.alertsTable.moreActionsTextLabel', {
    defaultMessage: 'More actions'
  });
  const onExpandEvent = () => {
    onExpandedAlertIndexChange(rowIndex);
  };
  const hideViewInApp = isInApp || viewInAppUrl === '' || parentAlert;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !parentAlert && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "expand-event-tool-tip",
    content: VIEW_DETAILS,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "expand-event",
    iconType: "expand",
    onClick: onExpandEvent,
    size: "s",
    color: "text",
    "aria-label": VIEW_DETAILS,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 13
    }
  }))), !hideViewInApp && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.observability.alertsTable.viewInAppTextLabel', {
      defaultMessage: 'View in app'
    }),
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "o11yAlertActionsButton",
    "aria-label": _i18n.i18n.translate('xpack.observability.alertsTable.viewInAppTextLabel', {
      defaultMessage: 'View in app'
    }),
    color: "text",
    onMouseOver: handleViewInAppUrl,
    onClick: () => window.open(viewInAppUrl),
    iconType: "eye",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      textAlign: 'center'
    },
    grow: parentAlert ? false : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: actionsToolTip,
      disableScreenReaderOutput: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": actionsToolTip,
      color: "text",
      "data-test-subj": "alertsTableRowActionMore",
      display: "empty",
      iconType: "boxesHorizontal",
      onClick: toggleActionsPopover,
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 15
      }
    })),
    closePopover: closeActionsPopover,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: actionsMenuItems,
    "data-test-subj": "alertsTableActionsMenu",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }))));
}

// Default export used for lazy loading
// eslint-disable-next-line import/no-default-export
var _default = exports.default = AlertActions;
const VIEW_DETAILS = _i18n.i18n.translate('xpack.observability.alertsTable.viewDetailsTextLabel', {
  defaultMessage: 'Alert details'
});