"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogoIcon = LogoIcon;
exports.isSupportedLogo = isSupportedLogo;
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/shared/logo_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function isSupportedLogo(logo) {
  return ['aws', 'azure', 'docker', 'dotnet', 'prometheus', 'gcp', 'java', 'javascript', 'kubernetes', 'nginx', 'system', 'apache', 'opentelemetry', 'mysql', 'postgresql', 'redis', 'ruby', 'haproxy', 'rabbitmq', 'kafka', 'mongodb', 'apache_tomcat', 'linux', 'apple'].includes(logo);
}
function useIconForLogo(logo) {
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  if (!logo) return undefined;
  switch (logo) {
    case 'aws':
      return 'logoAWS';
    case 'azure':
      return 'logoAzure';
    case 'gcp':
      return 'logoGCP';
    case 'kubernetes':
      return 'logoKubernetes';
    case 'nginx':
      return 'logoNginx';
    case 'prometheus':
      return 'logoPrometheus';
    case 'docker':
      return 'logoDocker';
    default:
      return http === null || http === void 0 ? void 0 : http.staticAssets.getPluginAssetHref(`${logo}.svg`);
  }
}
function isAvatarSize(size) {
  return size !== 'original' && size !== 'xxl';
}
function LogoIcon({
  logo,
  euiIconType,
  isAvatar,
  size,
  className
}) {
  const iconType = useIconForLogo(logo);
  if (euiIconType && isAvatar && isAvatarSize(size)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      color: "subdued",
      iconType: euiIconType,
      name: "logoIcon",
      size: size,
      className: className,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 7
      }
    });
  }
  if (iconType || euiIconType) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: euiIconType !== null && euiIconType !== void 0 ? euiIconType : iconType,
      size: size,
      className: className,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 12
      }
    });
  }
  return null;
}