"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.starterPromptRt = exports.screenContextRt = exports.publicMessageRt = exports.messageRt = exports.functionRt = exports.deanonymizationRt = exports.conversationUpdateRt = exports.conversationCreateRt = exports.assistantScopeType = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _types = require("../../common/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deanonymizationRt = exports.deanonymizationRt = t.type({
  start: t.number,
  end: t.number,
  entity: t.type({
    class_name: t.string,
    value: t.string,
    mask: t.string
  })
});
const messageRt = exports.messageRt = t.type({
  '@timestamp': t.string,
  message: t.intersection([t.type({
    role: t.union([t.literal(_types.MessageRole.System), t.literal(_types.MessageRole.Assistant), t.literal(_types.MessageRole.Function), t.literal(_types.MessageRole.User), t.literal(_types.MessageRole.Elastic)])
  }), t.partial({
    content: t.string,
    name: t.string,
    event: t.string,
    data: t.string,
    function_call: t.intersection([t.type({
      name: t.string,
      trigger: t.union([t.literal(_types.MessageRole.Assistant), t.literal(_types.MessageRole.User), t.literal(_types.MessageRole.Elastic)])
    }), t.partial({
      arguments: t.string
    })]),
    deanonymizations: t.array(deanonymizationRt)
  })])
});
const publicMessageRt = exports.publicMessageRt = t.type({
  '@timestamp': t.string,
  message: t.intersection([t.type({
    role: t.union([t.literal(_types.MessageRole.System), t.literal(_types.MessageRole.Assistant), t.literal(_types.MessageRole.Function), t.literal(_types.MessageRole.User), t.literal(_types.MessageRole.Elastic)])
  }), t.partial({
    content: t.string,
    name: t.string,
    event: t.string,
    data: t.string,
    function_call: t.intersection([t.type({
      name: t.string,
      trigger: t.union([t.literal(_types.MessageRole.Assistant), t.literal(_types.MessageRole.User), t.literal(_types.MessageRole.Elastic)])
    }), t.partial({
      arguments: t.string
    })])
  })])
});
const tokenCountRt = t.type({
  prompt: t.number,
  completion: t.number,
  total: t.number
});
const conversationCreateRt = exports.conversationCreateRt = t.intersection([t.type({
  '@timestamp': t.string,
  conversation: t.type({
    title: t.string
  }),
  messages: t.array(messageRt),
  labels: t.record(t.string, t.string),
  numeric_labels: t.record(t.string, t.number),
  public: _ioTsUtils.toBooleanRt
}), t.partial({
  systemMessage: t.string,
  archived: _ioTsUtils.toBooleanRt
})]);
const assistantScopeType = exports.assistantScopeType = t.union([t.literal('observability'), t.literal('search'), t.literal('all')]);
const conversationUpdateRt = exports.conversationUpdateRt = t.intersection([conversationCreateRt, t.type({
  conversation: t.intersection([t.type({
    id: t.string,
    title: t.string
  }), t.partial({
    token_count: tokenCountRt // deprecated, but kept for backwards compatibility
  })])
})]);
const functionRt = exports.functionRt = t.intersection([t.type({
  name: t.string,
  description: t.string
}), t.partial({
  parameters: t.any
})]);
const starterPromptRt = exports.starterPromptRt = t.intersection([t.type({
  title: t.string,
  prompt: t.string,
  icon: t.any
}), t.partial({
  scopes: t.array(assistantScopeType)
})]);
const screenContextRt = exports.screenContextRt = t.partial({
  description: t.string,
  data: t.array(t.type({
    name: t.string,
    description: t.string,
    value: t.any
  })),
  actions: t.array(functionRt),
  screenDescription: t.string,
  starterPrompts: t.array(starterPromptRt)
});