"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLastUserMessage = getLastUserMessage;
var _lodash = require("lodash");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLastUserMessage(messages) {
  const lastUserMessage = (0, _lodash.last)(messages.filter(message => message.message.role === _common.MessageRole.User && message.message.name === undefined));
  return lastUserMessage === null || lastUserMessage === void 0 ? void 0 : lastUserMessage.message.content;
}