"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toolCallEventType = exports.toolCallEvent = void 0;
var _analytics = require("../../common/analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const schema = {
  toolName: {
    type: 'text',
    _meta: {
      description: 'The name of the tool that was called'
    }
  },
  connector: {
    properties: _analytics.connectorSchema
  },
  scopes: _analytics.scopeSchema
};
const toolCallEventType = exports.toolCallEventType = 'observability_ai_assistant_tool_call';
const toolCallEvent = exports.toolCallEvent = {
  eventType: toolCallEventType,
  schema
};