"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createService = createService;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _create_function_request_message = require("../../common/utils/create_function_request_message");
var _create_function_response_message = require("../../common/utils/create_function_response_message");
var _api = require("../api");
var _default_starter_prompts = require("./default_starter_prompts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function createService({
  analytics,
  coreStart,
  enabled,
  scopes,
  scopeIsMutable
}) {
  const apiClient = (0, _api.createCallObservabilityAIAssistantAPI)(coreStart);
  const registrations = [];
  const screenContexts$ = new _rxjs.BehaviorSubject([{
    starterPrompts: _default_starter_prompts.defaultStarterPrompts
  }]);
  const predefinedConversation$ = new _rxjs.Subject();
  const scope$ = new _rxjs.BehaviorSubject(scopes);
  const getScreenContexts = () => {
    const currentScopes = scope$.value;
    const screenContexts = screenContexts$.value.map(({
      starterPrompts,
      ...rest
    }) => ({
      ...rest,
      starterPrompts: starterPrompts === null || starterPrompts === void 0 ? void 0 : starterPrompts.filter((0, _aiAssistantCommon.filterScopes)(currentScopes))
    }));
    return screenContexts;
  };
  return {
    isEnabled: () => {
      return enabled;
    },
    register: fn => {
      registrations.push(fn);
    },
    start: async ({
      signal
    }) => {
      const mod = await Promise.resolve().then(() => _interopRequireWildcard(require('./create_chat_service')));
      return await mod.createChatService({
        analytics,
        apiClient,
        signal,
        registrations,
        scope$
      });
    },
    callApi: apiClient,
    getScreenContexts,
    setScreenContext: context => {
      screenContexts$.next(screenContexts$.value.concat(context));
      function unsubscribe() {
        screenContexts$.next((0, _lodash.without)(screenContexts$.value, context));
      }
      return unsubscribe;
    },
    navigate: async cb => {
      cb();

      // wait for at least 1s of no network activity
      await (0, _rxjs.lastValueFrom)(coreStart.http.getLoadingCount$().pipe((0, _rxjs.filter)(count => count === 0), (0, _rxjs.debounceTime)(1000), (0, _rxjs.take)(1)));
      return (0, _rxjs.of)((0, _create_function_request_message.createFunctionRequestMessage)({
        name: 'context'
      }), (0, _create_function_response_message.createFunctionResponseMessage)({
        name: 'context',
        content: {
          screenDescription: (0, _lodash.compact)(getScreenContexts().map(context => context.screenDescription)).join('\n\n')
        }
      }));
    },
    conversations: {
      openNewConversation: ({
        messages,
        title,
        hideConversationList = false
      }) => {
        predefinedConversation$.next({
          messages,
          title,
          hideConversationList
        });
      },
      predefinedConversation$: predefinedConversation$.asObservable()
    },
    setScopes: newScopes => {
      if (!scopeIsMutable) {
        scope$.next(newScopes);
      }
    },
    getScopes: () => scope$.value,
    scope$
  };
}