"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsTab = SettingsTab;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _hooks = require("@kbn/ai-assistant/src/hooks");
var _use_kibana = require("../../../hooks/use_kibana");
var _ui_settings = require("./ui_settings");
var _product_doc_setting = require("./product_doc_setting");
var _change_kb_model = require("./change_kb_model");
var _inference_utils = require("../../../helpers/inference_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/observability_ai_assistant_management/public/routes/components/settings_tab/settings_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SettingsTab() {
  var _knowledgeBase$status, _knowledgeBase$status2, _connectors$connector, _connectors$connector2;
  const {
    productDocBase
  } = (0, _use_kibana.useKibana)().services;
  const knowledgeBase = (0, _hooks.useKnowledgeBase)();
  const currentlyDeployedInferenceId = (0, _inference_utils.getMappedInferenceId)((_knowledgeBase$status = knowledgeBase.status.value) === null || _knowledgeBase$status === void 0 ? void 0 : _knowledgeBase$status.currentInferenceId);
  const connectors = (0, _hooks.useGenAIConnectors)();
  const kbEnabled = Boolean((_knowledgeBase$status2 = knowledgeBase.status.value) === null || _knowledgeBase$status2 === void 0 ? void 0 : _knowledgeBase$status2.enabled);
  const hasConnectors = ((_connectors$connector = (_connectors$connector2 = connectors.connectors) === null || _connectors$connector2 === void 0 ? void 0 : _connectors$connector2.length) !== null && _connectors$connector !== void 0 ? _connectors$connector : 0) > 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, kbEnabled && hasConnectors && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_change_kb_model.ChangeKbModel, {
    knowledgeBase: knowledgeBase,
    currentlyDeployedInferenceId: currentlyDeployedInferenceId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 11
    }
  }), productDocBase && /*#__PURE__*/_react.default.createElement(_product_doc_setting.ProductDocSetting, {
    knowledgeBase: knowledgeBase,
    currentlyDeployedInferenceId: currentlyDeployedInferenceId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_ui_settings.UISettings, {
    knowledgeBase: knowledgeBase,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }));
}