"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerChangesRenderFunction = registerChangesRenderFunction;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _change_list = require("../../components/changes/change_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_ai_assistant_app/public/functions/changes/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function sortAndGroup(groups) {
  const grouped = (0, _lodash.mapValues)((0, _lodash.groupBy)(groups, 'name'), (items, key) => {
    return {
      name: key,
      items: (0, _lodash.orderBy)(items, item => {
        var _item$changes$p_value, _item$changes;
        return (_item$changes$p_value = (_item$changes = item.changes) === null || _item$changes === void 0 ? void 0 : _item$changes.p_value) !== null && _item$changes$p_value !== void 0 ? _item$changes$p_value : Number.POSITIVE_INFINITY;
      })
    };
  });
  return (0, _lodash.orderBy)(grouped, group => {
    var _group$items$0$change, _group$items$0$change2;
    return (_group$items$0$change = (_group$items$0$change2 = group.items[0].changes) === null || _group$items$0$change2 === void 0 ? void 0 : _group$items$0$change2.p_value) !== null && _group$items$0$change !== void 0 ? _group$items$0$change : Number.POSITIVE_INFINITY;
  });
}
function getImpactFromPValue(pValue) {
  if (pValue < 1e-6) {
    return _change_list.ChangeListItemImpact.high;
  }
  if (pValue < 0.001) {
    return _change_list.ChangeListItemImpact.medium;
  }
  return _change_list.ChangeListItemImpact.low;
}
function toChangeListItem(item) {
  return {
    label: 'regex' in item ? item.regex : item.key,
    timeseries: item.over_time,
    change: item.changes && item.changes.p_value !== undefined && item.changes.time !== undefined ? {
      impact: getImpactFromPValue(item.changes.p_value),
      time: new Date(item.changes.time).getTime(),
      type: item.changes.type
    } : undefined
  };
}
function LogChanges({
  logs
}) {
  const logsGroupedAndSorted = sortAndGroup(logs);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, logsGroupedAndSorted.map(group => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_change_list.ChangeList, {
    title: group.name,
    items: group.items.map(toChangeListItem),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }))));
}
function MetricChanges({
  metrics
}) {
  const metricsGroupedAndSorted = sortAndGroup(metrics);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, metricsGroupedAndSorted.map(group => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_change_list.ChangeList, {
    title: group.name,
    items: group.items.map(toChangeListItem),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }))));
}
function registerChangesRenderFunction({
  registerRenderFunction,
  pluginsStart
}) {
  const renderFunction = ({
    arguments: args,
    response
  }) => {
    const {
      data: {
        changes: {
          metrics,
          logs
        }
      }
    } = response;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 7
      }
    }, logs.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(LogChanges, {
      logs: logs,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 13
      }
    })) : null, metrics.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(MetricChanges, {
      metrics: metrics,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 13
      }
    })) : null);
  };
  registerRenderFunction('changes', renderFunction);
}