"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getClusterFromClusters = getClusterFromClusters;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getClusterFromClusters(clusters, globalState, unsetGlobalState = false) {
  const cluster = (() => {
    const existingCurrent = (0, _lodash.find)(clusters, {
      cluster_uuid: globalState.cluster_uuid
    });
    if (existingCurrent) {
      return existingCurrent;
    }
    const firstCluster = (0, _lodash.first)(clusters);
    if (firstCluster && firstCluster.cluster_uuid) {
      return firstCluster;
    }
    return null;
  })();
  if (cluster && cluster.license) {
    globalState.cluster_uuid = unsetGlobalState ? undefined : cluster.cluster_uuid;
    globalState.ccs = unsetGlobalState ? undefined : cluster.ccs;
    if (globalState.save) {
      globalState.save();
    }
    return cluster;
  }
  return null;
}