"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogStashPipelinePage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _global_state_context = require("../../contexts/global_state_context");
var _list = require("../../../components/logstash/pipeline_viewer/models/list");
var _pipeline_viewer = require("../../../components/logstash/pipeline_viewer");
var _pipeline = require("../../../components/logstash/pipeline_viewer/models/pipeline");
var _pipeline_state = require("../../../components/logstash/pipeline_viewer/models/pipeline_state");
var _vertex_factory = require("../../../components/logstash/pipeline_viewer/models/graph/vertex_factory");
var _logstash_template = require("./logstash_template");
var _use_table = require("../../hooks/use_table");
var _external_config_context = require("../../contexts/external_config_context");
var _common = require("../../../../common");
var _constants = require("../../../../common/constants");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _pipeline_versions_dropdown = require("./pipeline_versions_dropdown");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/logstash/pipeline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogStashPipelinePage = ({
  clusters
}) => {
  var _services$data2;
  const match = (0, _reactRouterDom.useRouteMatch)();
  const {
    hash: pipelineHash,
    id: pipelineId
  } = match.params;
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const {
    services
  } = (0, _public.useKibana)();
  const clusterUuid = globalState.cluster_uuid;
  const {
    minIntervalSeconds
  } = (0, _react.useContext)(_external_config_context.ExternalConfigContext);
  const dateFormat = (0, _public.useUiSetting)('dateFormat');
  const [pipelineState, setPipelineState] = (0, _react.useState)(null);
  const ccs = globalState.ccs;
  const cluster = (0, _lodash.find)(clusters, {
    cluster_uuid: clusterUuid
  });
  const [data, setData] = (0, _react.useState)({});
  const [detailVertexId, setDetailVertexId] = (0, _react.useState)(undefined);
  const {
    updateTotalItemCount
  } = (0, _use_table.useTable)('logstash.pipelines');
  const title = _i18n.i18n.translate('xpack.monitoring.logstash.pipeline.routeTitle', {
    defaultMessage: 'Logstash - Pipeline'
  });
  const pageTitle = _i18n.i18n.translate('xpack.monitoring.logstash.pipeline.pageTitle', {
    defaultMessage: 'Logstash pipeline: {pipeline}',
    values: {
      pipeline: data.pipeline ? data.pipeline.id : ''
    }
  });
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    const url = pipelineHash ? `../api/monitoring/v1/clusters/${clusterUuid}/logstash/pipeline/${pipelineId}/${pipelineHash}` : `../api/monitoring/v1/clusters/${clusterUuid}/logstash/pipeline/${pipelineId}`;
    const response = await ((_services$http = services.http) === null || _services$http === void 0 ? void 0 : _services$http.fetch(url, {
      method: 'POST',
      body: JSON.stringify({
        ccs,
        detailVertexId: detailVertexId || undefined,
        timeRange: {
          min: bounds.min.toISOString(),
          max: bounds.max.toISOString()
        }
      })
    }));
    const myData = response;
    myData.versions = myData.versions.map(version => {
      const relativeFirstSeen = (0, _common.formatTimestampToDuration)(version.firstSeen, _constants.CALCULATE_DURATION_SINCE);
      const relativeLastSeen = (0, _common.formatTimestampToDuration)(version.lastSeen, _constants.CALCULATE_DURATION_SINCE);
      const fudgeFactorSeconds = 2 * minIntervalSeconds;
      const isLastSeenCloseToNow = Date.now() - version.lastSeen <= fudgeFactorSeconds * 1000;
      return {
        ...version,
        relativeFirstSeen: _i18n.i18n.translate('xpack.monitoring.logstash.pipeline.relativeFirstSeenAgoLabel', {
          defaultMessage: '{relativeFirstSeen} ago',
          values: {
            relativeFirstSeen
          }
        }),
        relativeLastSeen: isLastSeenCloseToNow ? _i18n.i18n.translate('xpack.monitoring.logstash.pipeline.relativeLastSeenNowLabel', {
          defaultMessage: 'now'
        }) : _i18n.i18n.translate('xpack.monitoring.logstash.pipeline.relativeLastSeenAgoLabel', {
          defaultMessage: 'until {relativeLastSeen} ago',
          values: {
            relativeLastSeen
          }
        })
      };
    });
    setData(myData);
    updateTotalItemCount(response.totalNodeCount);
  }, [ccs, clusterUuid, services.http, updateTotalItemCount, detailVertexId, minIntervalSeconds, pipelineHash, pipelineId, (_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter]);
  (0, _react.useEffect)(() => {
    if (data.pipeline) {
      setPipelineState(new _pipeline_state.PipelineState(data.pipeline));
    }
  }, [data]);
  const timeseriesTooltipXValueFormatter = xValue => (0, _moment.default)(xValue).format(dateFormat);
  const {
    generate: generateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  const onVertexChange = (0, _react.useCallback)(vertex => {
    if (!vertex) {
      setDetailVertexId(null);
    } else {
      setDetailVertexId(vertex.id);
    }
  }, []);
  (0, _react.useEffect)(() => {
    if (detailVertexId !== undefined) {
      getPageData();
    }
  }, [detailVertexId, getPageData]);
  const onChangePipelineHash = (0, _react.useCallback)(hash => {
    window.location.hash = (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/logstash/pipelines/${pipelineId}/${hash}`);
  }, [pipelineId]);
  (0, _react.useEffect)(() => {
    if (cluster) {
      generateBreadcrumbs(cluster.cluster_name, {
        inLogstash: true,
        page: 'pipeline'
      });
    }
  }, [cluster, data, generateBreadcrumbs]);
  return /*#__PURE__*/_react.default.createElement(_logstash_template.LogstashTemplate, {
    tabsDisabled: true,
    title: title,
    pageTitle: pageTitle,
    getPageData: getPageData,
    cluster: cluster,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_pipeline_versions_dropdown.PipelineVersions, {
    pipelineVersions: data.versions,
    onChangePipelineHash: onChangePipelineHash,
    pipelineHash: pipelineHash,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 9
    }
  })), pipelineState && /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_pipeline_viewer.PipelineViewer, {
    pipeline: _list.List.fromPipeline(_pipeline.Pipeline.fromPipelineGraph(pipelineState.config.graph)),
    timeseriesTooltipXValueFormatter: timeseriesTooltipXValueFormatter,
    setDetailVertexId: onVertexChange,
    detailVertex: data.vertex ? (0, _vertex_factory.vertexFactory)(null, data.vertex) : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 11
    }
  })));
};
exports.LogStashPipelinePage = LogStashPipelinePage;