"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaInstancePage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _global_state_context = require("../../contexts/global_state_context");
var _use_charts = require("../../hooks/use_charts");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _chart = require("../../../components/chart");
var _detail_status = require("../../../components/kibana/detail_status");
var _page_template = require("../page_template");
var _callout = require("../../../alerts/callout");
var _fetch_alerts = require("../../../lib/fetch_alerts");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/kibana/instance.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const KibanaInstance = ({
  data,
  alerts
}) => {
  const {
    zoomInfo,
    onBrush
  } = (0, _use_charts.useCharts)();
  const showRules = data.metrics.kibana_instance_rule_executions && data.metrics.kibana_instance_rule_executions.length && data.metrics.kibana_instance_rule_executions[0].indices_found.ecs;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_detail_status.DetailStatus, {
    stats: data.kibanaSummary,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_callout.AlertsCallout, {
    alerts: alerts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
    series: data.metrics.kibana_requests,
    onBrush: onBrush,
    zoomInfo: zoomInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
    series: data.metrics.kibana_response_times,
    onBrush: onBrush,
    zoomInfo: zoomInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
    series: data.metrics.kibana_memory,
    onBrush: onBrush,
    zoomInfo: zoomInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
    series: data.metrics.kibana_average_concurrent_connections,
    onBrush: onBrush,
    zoomInfo: zoomInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
    series: data.metrics.kibana_os_load,
    onBrush: onBrush,
    zoomInfo: zoomInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
    series: data.metrics.kibana_process_delay,
    onBrush: onBrush,
    zoomInfo: zoomInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  })), showRules && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
    series: data.metrics.kibana_instance_rule_executions,
    onBrush: onBrush,
    zoomInfo: zoomInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
    series: data.metrics.kibana_instance_rule_failures,
    onBrush: onBrush,
    zoomInfo: zoomInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
    series: data.metrics.kibana_instance_action_executions,
    onBrush: onBrush,
    zoomInfo: zoomInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_chart.MonitoringTimeseriesContainer, {
    series: data.metrics.kibana_instance_action_failures,
    onBrush: onBrush,
    zoomInfo: zoomInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 19
    }
  })))))));
};
const KibanaInstancePage = ({
  clusters
}) => {
  var _services$data2;
  const {
    instance
  } = (0, _reactRouterDom.useParams)();
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const {
    services
  } = (0, _public.useKibana)();
  const {
    generate: generateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  const clusterUuid = globalState.cluster_uuid;
  const ccs = globalState.ccs;
  const cluster = (0, _lodash.find)(clusters, {
    cluster_uuid: clusterUuid
  });
  const [data, setData] = (0, _react.useState)({});
  const [instanceName, setInstanceName] = (0, _react.useState)('');
  const [alerts, setAlerts] = (0, _react.useState)({});
  const title = `Kibana - ${instanceName}`;
  const pageTitle = _i18n.i18n.translate('xpack.monitoring.kibana.instance.pageTitle', {
    defaultMessage: 'Kibana instance: {instance}',
    values: {
      instance: instanceName
    }
  });
  (0, _react.useEffect)(() => {
    if (cluster) {
      generateBreadcrumbs(cluster.cluster_name, {
        inKibana: true,
        instance: instanceName
      });
    }
  }, [cluster, instanceName, generateBreadcrumbs]);
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    const url = `../api/monitoring/v1/clusters/${clusterUuid}/kibana/${instance}`;
    if ((_services$http = services.http) !== null && _services$http !== void 0 && _services$http.fetch && clusterUuid) {
      var _services$http2;
      const response = await ((_services$http2 = services.http) === null || _services$http2 === void 0 ? void 0 : _services$http2.fetch(url, {
        method: 'POST',
        body: JSON.stringify({
          ccs,
          timeRange: {
            min: bounds.min.toISOString(),
            max: bounds.max.toISOString()
          }
        })
      }));
      setData(response);
      setInstanceName(response.kibanaSummary.name);
      const alertsResponse = await (0, _fetch_alerts.fetchAlerts)({
        fetch: services.http.fetch,
        alertTypeIds: [_constants.RULE_KIBANA_VERSION_MISMATCH],
        clusterUuid,
        timeRange: {
          min: bounds.min.valueOf(),
          max: bounds.max.valueOf()
        }
      });
      setAlerts(alertsResponse);
    }
  }, [ccs, clusterUuid, instance, (_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http]);
  return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, {
    title: title,
    pageTitle: pageTitle,
    getPageData: getPageData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "kibanaInstancePage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(KibanaInstance, {
    data: data,
    alerts: alerts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  })));
};
exports.KibanaInstancePage = KibanaInstancePage;