"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTitle = useTitle;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: verify that works for all pages
function useTitle(cluster, suffix) {
  var _services$chrome;
  const {
    services
  } = (0, _public.useKibana)();
  let clusterName = (0, _lodash.get)(cluster, 'cluster_name');
  clusterName = clusterName ? `- ${clusterName}` : '';
  suffix = suffix ? `- ${suffix}` : '';
  (_services$chrome = services.chrome) === null || _services$chrome === void 0 ? void 0 : _services$chrome.docTitle.change(_i18n.i18n.translate('xpack.monitoring.stackMonitoringDocTitle', {
    defaultMessage: 'Stack Monitoring {clusterName} {suffix}',
    values: {
      clusterName,
      suffix
    }
  }));
}