"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Expression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_derived_index_pattern = require("../components/param_details_form/use_derived_index_pattern");
var _kuery = require("../../lib/kuery");
var _kuery_bar = require("../../components/kuery_bar");
var _alert_param_duration = require("../flyout_expressions/alert_param_duration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/alerts/legacy_alert/expression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FILTER_TYPING_DEBOUNCE_MS = 500;
const Expression = ({
  ruleParams,
  config,
  setRuleParams,
  dataViews,
  errors,
  defaults,
  expressionConfig
}) => {
  var _ruleParams$duration;
  const {
    derivedIndexPattern
  } = (0, _use_derived_index_pattern.useDerivedIndexPattern)(dataViews, config);
  const onFilterChange = (0, _react.useCallback)(filter => {
    if (derivedIndexPattern) setRuleParams('filterQueryText', filter);
    if (derivedIndexPattern) setRuleParams('filterQuery', (0, _kuery.convertKueryToElasticSearchQuery)(filter, derivedIndexPattern) || '');
  }, [setRuleParams, derivedIndexPattern]);

  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const debouncedOnFilterChange = (0, _react.useCallback)((0, _lodash.debounce)(onFilterChange, FILTER_TYPING_DEBOUNCE_MS), [onFilterChange]);
  const kueryBar = derivedIndexPattern ? /*#__PURE__*/_react.default.createElement(_kuery_bar.KueryBar, {
    value: ruleParams.filterQueryText,
    derivedIndexPattern: derivedIndexPattern,
    onSubmit: onFilterChange,
    onChange: debouncedOnFilterChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  const duration = expressionConfig !== null && expressionConfig !== void 0 && expressionConfig.showDuration ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_param_duration.AlertParamDuration, {
    key: "duration",
    name: 'duration',
    duration: (_ruleParams$duration = ruleParams.duration) !== null && _ruleParams$duration !== void 0 ? _ruleParams$duration : defaults === null || defaults === void 0 ? void 0 : defaults.duration,
    label: _i18n.i18n.translate('xpack.monitoring.alerts.legacy.paramDetails.duration.label', {
      defaultMessage: 'In the last'
    }),
    errors: errors.duration,
    setRuleParams: setRuleParams,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, duration, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.monitoring.alerts.filterLable', {
      defaultMessage: 'Filter'
    }),
    helpText: _i18n.i18n.translate('xpack.monitoring.alerts.filterHelpText', {
      defaultMessage: 'Use a KQL expression to limit the scope of your alert trigger.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, kueryBar), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }));
};

// for lazy loading
// eslint-disable-next-line import/no-default-export
exports.Expression = Expression;
var _default = exports.default = Expression;