"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRuntimeMappings = isRuntimeMappings;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _is_runtime_field = require("./is_runtime_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Type guard for runtime mappings
 *
 * @param {unknown} arg - The item to be checked
 * @returns {arg is RuntimeMappings}
 */
function isRuntimeMappings(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg) && Object.values(arg).every(d => (0, _is_runtime_field.isRuntimeField)(d));
}

/**
 * Alias for `estypes.MappingRuntimeFields`.
 */