"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TAB_IDS = exports.SuppliedConfigurationsFlyout = exports.KIBANA_ASSETS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _supplied_configurations = require("../supplied_configurations");
var _overview_tab_content = require("./overview_tab_content");
var _jobs_tab_content = require("./jobs_tab_content");
var _kibana_tab_content = require("./kibana_tab_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/supplied_configurations/supplied_configurations_flyout/flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TAB_IDS = exports.TAB_IDS = {
  OVERVIEW: 'overview',
  JOBS: 'jobs',
  KIBANA: 'kibana'
};
const KIBANA_ASSETS = exports.KIBANA_ASSETS = {
  VISUALIZATION: 'visualization',
  DASHBOARD: 'dashboard',
  SEARCH: 'search'
};
const SuppliedConfigurationsFlyout = ({
  module,
  onClose
}) => {
  var _tabs$find;
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(TAB_IDS.OVERVIEW);
  const [selectedKibanaSubTab, setSelectedKibanaSubTab] = (0, _react.useState)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const tabs = (0, _react.useMemo)(() => {
    var _module$kibana;
    return [{
      id: TAB_IDS.OVERVIEW,
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.overviewTabLabel",
        defaultMessage: "Overview",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 11
        }
      }),
      content: /*#__PURE__*/_react.default.createElement(_overview_tab_content.OverviewTabContent, {
        module: module,
        setSelectedTabId: setSelectedTabId,
        setSelectedKibanaSubTab: setSelectedKibanaSubTab,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 11
        }
      })
    }, {
      id: TAB_IDS.JOBS,
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.jobsTabLabel",
        defaultMessage: "Jobs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 11
        }
      }),
      content: /*#__PURE__*/_react.default.createElement(_jobs_tab_content.JobsTabContent, {
        module: module,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 18
        }
      })
    }, ...((0, _mlIsPopulatedObject.isPopulatedObject)((_module$kibana = module.kibana) !== null && _module$kibana !== void 0 ? _module$kibana : {}) ? [{
      id: TAB_IDS.KIBANA,
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.kibanaTabLabel",
        defaultMessage: "Kibana",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 17
        }
      }),
      content: /*#__PURE__*/_react.default.createElement(_kibana_tab_content.KibanaTabContent, {
        module: module,
        selectedKibanaSubTab: selectedKibanaSubTab,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 17
        }
      })
    }] : [])];
  }, [module, selectedKibanaSubTab]);
  const renderTabs = (0, _react.useMemo)(() => tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => setSelectedTabId(tab.id),
    isSelected: tab.id === selectedTabId,
    key: tab.id,
    "data-test-subj": `mlSuppliedConfigurationsFlyoutTab ${tab.id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, tab.name)), [tabs, selectedTabId]);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "l",
    ownFocus: true,
    onClose: onClose,
    "aria-labelledby": flyoutTitleId,
    "data-test-subj": `mlSuppliedConfigurationsFlyout ${module.id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }, (0, _supplied_configurations.isLogoObject)(module.logo) ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xxl",
    type: module.logo.icon,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 42
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 15
    }
  }, module.title)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    css: {
      marginBottom: '-25px',
      paddingLeft: `${euiTheme.size.m}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, renderTabs)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }, (_tabs$find = tabs.find(tab => tab.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content));
};
exports.SuppliedConfigurationsFlyout = SuppliedConfigurationsFlyout;