"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuppliedConfigurations = void 0;
exports.isLogoObject = isLogoObject;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlUrlState = require("@kbn/ml-url-state");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _kibana = require("../contexts/kibana");
var _locator = require("../../../common/constants/locator");
var _loading_indicator = require("../components/loading_indicator");
var _utils = require("./utils");
var _supplied_configurations_flyout = require("./supplied_configurations_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/supplied_configurations/supplied_configurations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isLogoObject(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg) && Object.hasOwn(arg, 'icon');
}
const SCHEMA = {
  strict: true,
  fields: {
    tags: {
      type: 'string'
    }
  }
};
const SuppliedConfigurations = () => {
  const {
    services: {
      mlServices: {
        mlApi: {
          getDataRecognizerModule
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const [suppliedConfigurationsPageState, setSuppliedConfigurationsPageState] = (0, _mlUrlState.usePageUrlState)(_locator.ML_PAGES.SUPPLIED_CONFIGURATIONS, {
    queryText: ''
  });
  const [modules, setModules] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [searchError, setSearchError] = (0, _react.useState)();
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const [selectedModuleId, setSelectedModuleId] = (0, _react.useState)();
  const closeFlyout = () => setIsFlyoutVisible(false);
  const isMounted = (0, _useMountedState.default)();

  /**
   * Loads recognizer module configuration.
   */
  const loadModules = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    try {
      const modulesReponse = await getDataRecognizerModule();
      if (isMounted()) {
        setModules(modulesReponse);
      }
    } catch (e) {
      // eslint-disable-next-line no-console
      console.error(e);
    }
    setIsLoading(false);
  }, [getDataRecognizerModule, isMounted]);
  (0, _useMount.default)(loadModules);
  const filters = (0, _react.useMemo)(() => {
    const options = [];
    const tags = new Set(modules.map(module => module.tags).flat());
    tags.forEach(tag => {
      if (tag === undefined) return;
      options.push({
        value: tag,
        view: tag
      });
    });
    return [{
      type: 'field_value_selection',
      field: 'tags',
      name: 'Tags',
      filterWith: 'includes',
      multiSelect: 'or',
      options
    }];
  }, [modules]);
  const setSearchQueryText = (0, _react.useCallback)(value => {
    setSuppliedConfigurationsPageState({
      queryText: value
    });
  }, [setSuppliedConfigurationsPageState]);
  const query = (0, _react.useMemo)(() => {
    const searchQueryText = suppliedConfigurationsPageState.queryText;
    return searchQueryText !== '' ? _eui.EuiSearchBar.Query.parse(searchQueryText) : undefined;
  }, [suppliedConfigurationsPageState]);
  const onChange = search => {
    if (search.error !== null) {
      setSearchError(search.error.message);
      return;
    }
    setSearchError(undefined);
    setSearchQueryText(search.queryText);
  };
  const filteredModules = (0, _react.useMemo)(() => {
    var _query$ast$clauses, _query$ast;
    const clauses = (_query$ast$clauses = query === null || query === void 0 ? void 0 : (_query$ast = query.ast) === null || _query$ast === void 0 ? void 0 : _query$ast.clauses) !== null && _query$ast$clauses !== void 0 ? _query$ast$clauses : [];
    return clauses.length > 0 ? (0, _utils.filterModules)(modules, clauses) : modules;
  }, [query, modules]);
  if (isLoading === true) return /*#__PURE__*/_react.default.createElement(_loading_indicator.LoadingIndicator, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 34
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    defaultQuery: query,
    box: {
      placeholder: _i18n.i18n.translate('xpack.ml.anomalyDetection.suppliedConfigurationsPage.searchBarPlaceholder', {
        defaultMessage: 'Search supplied configurations'
      }),
      incremental: true,
      schema: SCHEMA
    },
    filters: filters,
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "mlAnomalyJobSelectionControls",
    isInvalid: searchError !== undefined,
    error: searchError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "l",
    columns: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }, filteredModules.map(({
    description,
    id,
    logo,
    title
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: id,
      "data-test-subj": "mlSuppliedConfigurationsCard",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      "data-test-subj": `mlSuppliedConfigurationsCard ${id}`,
      layout: "horizontal",
      icon: isLogoObject(logo) ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "xxl",
        type: logo.icon,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 44
        }
      }) : null,
      title: title,
      description: description,
      onClick: () => {
        setIsFlyoutVisible(true);
        setSelectedModuleId(id);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 15
      }
    }));
  })), isFlyoutVisible && selectedModuleId ? /*#__PURE__*/_react.default.createElement(_supplied_configurations_flyout.SuppliedConfigurationsFlyout, {
    module: modules.find(({
      id
    }) => id === selectedModuleId),
    onClose: closeFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }) : null);
};
exports.SuppliedConfigurations = SuppliedConfigurations;