"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeSeriesExplorerRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _locator = require("../../../../locator");
var _kibana = require("../../../contexts/kibana");
var _explorer_utils = require("../../../explorer/explorer_utils");
var _job_service = require("../../../services/job_service");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _breadcrumbs = require("../../breadcrumbs");
var _annotations_service = require("../../../services/annotations_service");
var _ml_annotation_updates_context = require("../../../contexts/ml/ml_annotation_updates_context");
var _resolvers = require("../../resolvers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/routes/timeseriesexplorer/timeseriesexplorer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TimeSeriesExplorerUrlStateManager = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./state_manager')))).TimeSeriesExplorerUrlStateManager
}));
const timeSeriesExplorerRouteFactory = (navigateToPath, basePath) => ({
  id: 'timeseriesexplorer',
  path: (0, _router.createPath)(_locator.ML_PAGES.SINGLE_METRIC_VIEWER),
  title: _i18n.i18n.translate('xpack.ml.anomalyDetection.singleMetricViewerLabel', {
    defaultMessage: 'Single Metric Viewer'
  }),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 28
    }
  })),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.anomalyDetection.singleMetricViewerLabel', {
      defaultMessage: 'Single Metric Viewer'
    })
  }],
  enableDatePicker: true
});
exports.timeSeriesExplorerRouteFactory = timeSeriesExplorerRouteFactory;
const PageWrapper = ({
  deps
}) => {
  const mlApi = (0, _kibana.useMlApi)();
  const mlJobService = (0, _job_service.useMlJobService)();
  const uiSettings = (0, _kibana.useUiSettings)();
  const {
    context,
    results
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetJobs'], {
    ...(0, _resolvers.basicResolvers)(),
    jobs: mlJobService.loadJobsWrapper,
    jobsWithTimeRange: () => mlApi.jobs.jobsWithTimerange((0, _explorer_utils.getDateFormatTz)(uiSettings))
  });
  const annotationUpdatesService = (0, _react.useMemo)(() => new _annotations_service.AnnotationUpdatesService(), []);
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_ml_annotation_updates_context.MlAnnotationUpdatesContext.Provider, {
    value: annotationUpdatesService,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, results ? /*#__PURE__*/_react.default.createElement(TimeSeriesExplorerUrlStateManager, {
    config: uiSettings,
    jobsWithTimeRange: results.jobsWithTimeRange.jobs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }) : null));
};