"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.recognizeRouteFactory = exports.checkViewOrCreateRouteFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _queryString = require("query-string");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _resolvers = require("../../resolvers");
var _locator = require("../../../../locator");
var _kibana = require("../../../contexts/kibana");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _breadcrumbs = require("../../breadcrumbs");
var _use_create_ad_links = require("../../../components/custom_hooks/use_create_ad_links");
var _ml = require("../../../contexts/ml");
var _use_create_url = require("../../../contexts/kibana/use_create_url");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/routes/new_job/recognize.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Page = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('../../../jobs/new_job/recognize')))).Page
}));
const recognizeRouteFactory = navigateToApp => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_RECOGNIZER),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(PageWrapper, (0, _extends2.default)({}, props, {
    deps: deps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 28
    }
  })),
  breadcrumbs: [(0, _breadcrumbs.getStackManagementBreadcrumb)(navigateToApp), (0, _breadcrumbs.getMlManagementBreadcrumb)('ANOMALY_DETECTION_MANAGEMENT_BREADCRUMB', navigateToApp), (0, _breadcrumbs.getMlManagementBreadcrumb)('CREATE_JOB_MANAGEMENT_BREADCRUMB', navigateToApp), {
    text: _i18n.i18n.translate('xpack.ml.jobsBreadcrumbs.selectIndexOrSearchLabelRecognize', {
      defaultMessage: 'Recognized index'
    }),
    href: ''
  }]
});
exports.recognizeRouteFactory = recognizeRouteFactory;
const checkViewOrCreateRouteFactory = () => ({
  path: (0, _router.createPath)(_locator.ML_PAGES.ANOMALY_DETECTION_MODULES_VIEW_OR_CREATE),
  render: (props, deps) => /*#__PURE__*/_react.default.createElement(CheckViewOrCreateWrapper, (0, _extends2.default)({}, props, {
    deps: deps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 28
    }
  })),
  // no breadcrumbs since it's just a redirect
  breadcrumbs: []
});
exports.checkViewOrCreateRouteFactory = checkViewOrCreateRouteFactory;
const PageWrapper = ({
  location
}) => {
  const {
    id
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const mlApi = (0, _kibana.useMlApi)();
  const {
    context,
    results
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetJobs'], {
    ...(0, _resolvers.basicResolvers)(),
    existingJobsAndGroups: () => mlApi.jobs.getAllJobAndGroupIds()
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_ml.DataSourceContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, results ? /*#__PURE__*/_react.default.createElement(Page, {
    moduleId: id,
    existingGroupIds: results.existingJobsAndGroups.groupIds,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }) : null));
};
const CheckViewOrCreateWrapper = ({
  location
}) => {
  const {
    services: {
      notifications: {
        toasts
      },
      mlServices: {
        mlApi
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    id: moduleId,
    index: dataViewId
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const {
    createLinkWithUserDefaults
  } = (0, _use_create_ad_links.useCreateADLinks)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const navigateToMlManagementLink = (0, _use_create_url.useNavigateToManagementMlLink)('anomaly_detection');

  /**
   * Checks whether the jobs in a data recognizer module have been created.
   * Redirects to the Anomaly Explorer to view the jobs if they have been created,
   * or the recognizer job wizard for the module if not.
   */
  function checkViewOrCreateJobs() {
    return new Promise((resolve, reject) => {
      // Load the module, and check if the job(s) in the module have been created.
      // If so, load the jobs in the Anomaly Explorer.
      // Otherwise open the data recognizer wizard for the module.
      // Always want to call reject() so as not to load original page.
      mlApi.dataRecognizerModuleJobsExist({
        moduleId
      }).then(async resp => {
        if (resp.jobsExist === true) {
          // also honor user's time filter setting in Advanced Settings
          const url = createLinkWithUserDefaults('explorer', resp.jobs);
          await navigateToPath(url);
          reject();
        } else {
          await navigateToMlManagementLink(_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_RECOGNIZER, {
            id: moduleId,
            index: dataViewId
          });
          reject();
        }
      }).catch(async err => {
        toasts.addError(err, {
          title: _i18n.i18n.translate('xpack.ml.newJob.recognize.moduleCheckJobsExistWarningTitle', {
            defaultMessage: 'Error checking module {moduleId}',
            values: {
              moduleId
            }
          }),
          toastMessage: _i18n.i18n.translate('xpack.ml.newJob.recognize.moduleCheckJobsExistWarningDescription', {
            defaultMessage: 'An error occurred checking whether the jobs in the module have been created. Search the list for matching jobs or create new jobs.'
          })
        });
        await navigateToPath(`/jobs`);
        reject();
      });
    });
  }
  (0, _use_resolver.useRouteResolver)('full', ['canCreateJob'], {
    checkViewOrCreateJobs
  });
  return null;
};