"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageLoader = exports.MlRouter = void 0;
exports.createPath = createPath;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _mlUrlState = require("@kbn/ml-url-state");
var _ml_notifications_context = require("../contexts/ml/ml_notifications_context");
var _ml_page = require("../components/ml_page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762517116494486687/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/router.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// custom RouteProps making location non-optional

const PageLoader = ({
  context,
  children
}) => {
  const isLoading = !context.initialized;
  if (context !== null && context !== void 0 && context.resolvedComponent) {
    return context.resolvedComponent;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, !isLoading ? children : null);
};

/**
 * `MlRouter` is based on `BrowserRouter` and takes in `ScopedHistory` provided
 * by Kibana. `LegacyHashUrlRedirect` provides compatibility with legacy hash based URLs.
 * `UrlStateProvider` manages state stored in `_g/_a` URL parameters which can be
 * use in components further down via `useUrlState()`.
 */
exports.PageLoader = PageLoader;
const MlRouter = ({
  pageDeps,
  entryPoint
}) => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
  history: pageDeps.history,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 90,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_mlUrlState.UrlStateProvider, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 91,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_ml_notifications_context.MlNotificationsContextProvider, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 92,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_ml_page.MlPage, {
  pageDeps: pageDeps,
  entryPoint: entryPoint,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 93,
    columnNumber: 9
  }
}))));
exports.MlRouter = MlRouter;
function createPath(page, additionalPrefix) {
  return `/${page}${additionalPrefix ? `${additionalPrefix}` : ''}`;
}